/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.sharing.CollectionLinkMetadata;
import com.dropbox.core.v2.sharing.PathLinkMetadata;
import com.dropbox.core.v2.sharing.Visibility;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class LinkMetadata {
    protected final String url;
    protected final Visibility visibility;
    protected final Date expires;

    public LinkMetadata(String url, Visibility visibility, Date expires) {
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
        if (visibility == null) {
            throw new IllegalArgumentException("Required value for 'visibility' is null");
        }
        this.visibility = visibility;
        this.expires = LangUtil.truncateMillis(expires);
    }

    public LinkMetadata(String url, Visibility visibility) {
        this(url, visibility, null);
    }

    public String getUrl() {
        return this.url;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Date getExpires() {
        return this.expires;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.url, this.visibility, this.expires});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LinkMetadata other = (LinkMetadata)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.visibility != other.visibility && !this.visibility.equals((Object)other.visibility) || this.expires != other.expires && (this.expires == null || !this.expires.equals(other.expires)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LinkMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LinkMetadata value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (value instanceof PathLinkMetadata) {
                PathLinkMetadata.Serializer.INSTANCE.serialize((PathLinkMetadata)value, g2, collapse);
                return;
            }
            if (value instanceof CollectionLinkMetadata) {
                CollectionLinkMetadata.Serializer.INSTANCE.serialize((CollectionLinkMetadata)value, g2, collapse);
                return;
            }
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("url");
            StoneSerializers.string().serialize(value.url, g2);
            g2.writeFieldName("visibility");
            Visibility.Serializer.INSTANCE.serialize(value.visibility, g2);
            if (value.expires != null) {
                g2.writeFieldName("expires");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.expires, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public LinkMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            LinkMetadata value;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                String f_url = null;
                Visibility f_visibility = null;
                Date f_expires = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("url".equals(field)) {
                        f_url = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("visibility".equals(field)) {
                        f_visibility = Visibility.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("expires".equals(field)) {
                        f_expires = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_url == null) {
                    throw new JsonParseException(p, "Required field \"url\" missing.");
                }
                if (f_visibility == null) {
                    throw new JsonParseException(p, "Required field \"visibility\" missing.");
                }
                value = new LinkMetadata(f_url, f_visibility, f_expires);
            } else if ("".equals(tag)) {
                value = INSTANCE.deserialize(p, true);
            } else if ("path".equals(tag)) {
                value = PathLinkMetadata.Serializer.INSTANCE.deserialize(p, true);
            } else if ("collection".equals(tag)) {
                value = CollectionLinkMetadata.Serializer.INSTANCE.deserialize(p, true);
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

