/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ListFolderContinueError {
    public static final ListFolderContinueError RESET = new ListFolderContinueError().withTag(Tag.RESET);
    public static final ListFolderContinueError OTHER = new ListFolderContinueError().withTag(Tag.OTHER);
    private Tag _tag;
    private LookupError pathValue;

    private ListFolderContinueError() {
    }

    private ListFolderContinueError withTag(Tag _tag) {
        ListFolderContinueError result = new ListFolderContinueError();
        result._tag = _tag;
        return result;
    }

    private ListFolderContinueError withTagAndPath(Tag _tag, LookupError pathValue) {
        ListFolderContinueError result = new ListFolderContinueError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static ListFolderContinueError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ListFolderContinueError().withTagAndPath(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isReset() {
        return this._tag == Tag.RESET;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ListFolderContinueError) {
            ListFolderContinueError other = (ListFolderContinueError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case RESET: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ListFolderContinueError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListFolderContinueError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g2.writeStartObject();
                    this.writeTag("path", g2);
                    g2.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case RESET: {
                    g2.writeString("reset");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public ListFolderContinueError deserialize(JsonParser p) throws IOException, JsonParseException {
            ListFolderContinueError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = ListFolderContinueError.path(fieldValue);
            } else {
                value = "reset".equals(tag) ? RESET : OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        RESET,
        OTHER;

    }
}

