/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.CommitInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class GetTemporaryUploadLinkArg {
    protected final CommitInfo commitInfo;
    protected final double duration;

    public GetTemporaryUploadLinkArg(CommitInfo commitInfo, double duration) {
        if (commitInfo == null) {
            throw new IllegalArgumentException("Required value for 'commitInfo' is null");
        }
        this.commitInfo = commitInfo;
        if (duration < 60.0) {
            throw new IllegalArgumentException("Number 'duration' is smaller than 60.0");
        }
        if (duration > 14400.0) {
            throw new IllegalArgumentException("Number 'duration' is larger than 14400.0");
        }
        this.duration = duration;
    }

    public GetTemporaryUploadLinkArg(CommitInfo commitInfo) {
        this(commitInfo, 14400.0);
    }

    public CommitInfo getCommitInfo() {
        return this.commitInfo;
    }

    public double getDuration() {
        return this.duration;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.commitInfo, this.duration});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetTemporaryUploadLinkArg other = (GetTemporaryUploadLinkArg)obj;
            return (this.commitInfo == other.commitInfo || this.commitInfo.equals(other.commitInfo)) && this.duration == other.duration;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GetTemporaryUploadLinkArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetTemporaryUploadLinkArg value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("commit_info");
            CommitInfo.Serializer.INSTANCE.serialize(value.commitInfo, g2);
            g2.writeFieldName("duration");
            StoneSerializers.float64().serialize((Double)value.duration, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public GetTemporaryUploadLinkArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Double f_duration;
            CommitInfo f_commitInfo;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_commitInfo = null;
                f_duration = 14400.0;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("commit_info".equals(field)) {
                        f_commitInfo = (CommitInfo)CommitInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("duration".equals(field)) {
                        f_duration = StoneSerializers.float64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_commitInfo == null) {
                    throw new JsonParseException(p, "Required field \"commit_info\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GetTemporaryUploadLinkArg value = new GetTemporaryUploadLinkArg(f_commitInfo, f_duration);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

