/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.SharingInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class FileSharingInfo
extends SharingInfo {
    protected final String parentSharedFolderId;
    protected final String modifiedBy;

    public FileSharingInfo(boolean readOnly, String parentSharedFolderId, String modifiedBy) {
        super(readOnly);
        if (parentSharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'parentSharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
        if (modifiedBy != null) {
            if (modifiedBy.length() < 40) {
                throw new IllegalArgumentException("String 'modifiedBy' is shorter than 40");
            }
            if (modifiedBy.length() > 40) {
                throw new IllegalArgumentException("String 'modifiedBy' is longer than 40");
            }
        }
        this.modifiedBy = modifiedBy;
    }

    public FileSharingInfo(boolean readOnly, String parentSharedFolderId) {
        this(readOnly, parentSharedFolderId, null);
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly;
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.parentSharedFolderId, this.modifiedBy});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileSharingInfo other = (FileSharingInfo)obj;
            return this.readOnly == other.readOnly && (this.parentSharedFolderId == other.parentSharedFolderId || this.parentSharedFolderId.equals(other.parentSharedFolderId)) && (this.modifiedBy == other.modifiedBy || this.modifiedBy != null && this.modifiedBy.equals(other.modifiedBy));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileSharingInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileSharingInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("read_only");
            StoneSerializers.boolean_().serialize((Boolean)value.readOnly, g2);
            g2.writeFieldName("parent_shared_folder_id");
            StoneSerializers.string().serialize(value.parentSharedFolderId, g2);
            if (value.modifiedBy != null) {
                g2.writeFieldName("modified_by");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.modifiedBy, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public FileSharingInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_modifiedBy;
            String f_parentSharedFolderId;
            Boolean f_readOnly;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_readOnly = null;
                f_parentSharedFolderId = null;
                f_modifiedBy = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("read_only".equals(field)) {
                        f_readOnly = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("modified_by".equals(field)) {
                        f_modifiedBy = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_readOnly == null) {
                    throw new JsonParseException(p, "Required field \"read_only\" missing.");
                }
                if (f_parentSharedFolderId == null) {
                    throw new JsonParseException(p, "Required field \"parent_shared_folder_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileSharingInfo value = new FileSharingInfo(f_readOnly, f_parentSharedFolderId, f_modifiedBy);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

