/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.SingleUserLock;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class FileLockContent {
    public static final FileLockContent UNLOCKED = new FileLockContent().withTag(Tag.UNLOCKED);
    public static final FileLockContent OTHER = new FileLockContent().withTag(Tag.OTHER);
    private Tag _tag;
    private SingleUserLock singleUserValue;

    private FileLockContent() {
    }

    private FileLockContent withTag(Tag _tag) {
        FileLockContent result = new FileLockContent();
        result._tag = _tag;
        return result;
    }

    private FileLockContent withTagAndSingleUser(Tag _tag, SingleUserLock singleUserValue) {
        FileLockContent result = new FileLockContent();
        result._tag = _tag;
        result.singleUserValue = singleUserValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUnlocked() {
        return this._tag == Tag.UNLOCKED;
    }

    public boolean isSingleUser() {
        return this._tag == Tag.SINGLE_USER;
    }

    public static FileLockContent singleUser(SingleUserLock value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new FileLockContent().withTagAndSingleUser(Tag.SINGLE_USER, value);
    }

    public SingleUserLock getSingleUserValue() {
        if (this._tag != Tag.SINGLE_USER) {
            throw new IllegalStateException("Invalid tag: required Tag.SINGLE_USER, but was Tag." + this._tag.name());
        }
        return this.singleUserValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.singleUserValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof FileLockContent) {
            FileLockContent other = (FileLockContent)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case UNLOCKED: {
                    return true;
                }
                case SINGLE_USER: {
                    return this.singleUserValue == other.singleUserValue || this.singleUserValue.equals(other.singleUserValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<FileLockContent> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileLockContent value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case UNLOCKED: {
                    g2.writeString("unlocked");
                    break;
                }
                case SINGLE_USER: {
                    g2.writeStartObject();
                    this.writeTag("single_user", g2);
                    SingleUserLock.Serializer.INSTANCE.serialize(value.singleUserValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public FileLockContent deserialize(JsonParser p) throws IOException, JsonParseException {
            FileLockContent value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("unlocked".equals(tag)) {
                value = UNLOCKED;
            } else if ("single_user".equals(tag)) {
                SingleUserLock fieldValue = null;
                fieldValue = SingleUserLock.Serializer.INSTANCE.deserialize(p, true);
                value = FileLockContent.singleUser(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        UNLOCKED,
        SINGLE_USER,
        OTHER;

    }
}

