/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class DeleteError {
    public static final DeleteError TOO_MANY_WRITE_OPERATIONS = new DeleteError().withTag(Tag.TOO_MANY_WRITE_OPERATIONS);
    public static final DeleteError TOO_MANY_FILES = new DeleteError().withTag(Tag.TOO_MANY_FILES);
    public static final DeleteError OTHER = new DeleteError().withTag(Tag.OTHER);
    private Tag _tag;
    private LookupError pathLookupValue;
    private WriteError pathWriteValue;

    private DeleteError() {
    }

    private DeleteError withTag(Tag _tag) {
        DeleteError result = new DeleteError();
        result._tag = _tag;
        return result;
    }

    private DeleteError withTagAndPathLookup(Tag _tag, LookupError pathLookupValue) {
        DeleteError result = new DeleteError();
        result._tag = _tag;
        result.pathLookupValue = pathLookupValue;
        return result;
    }

    private DeleteError withTagAndPathWrite(Tag _tag, WriteError pathWriteValue) {
        DeleteError result = new DeleteError();
        result._tag = _tag;
        result.pathWriteValue = pathWriteValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPathLookup() {
        return this._tag == Tag.PATH_LOOKUP;
    }

    public static DeleteError pathLookup(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new DeleteError().withTagAndPathLookup(Tag.PATH_LOOKUP, value);
    }

    public LookupError getPathLookupValue() {
        if (this._tag != Tag.PATH_LOOKUP) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH_LOOKUP, but was Tag." + this._tag.name());
        }
        return this.pathLookupValue;
    }

    public boolean isPathWrite() {
        return this._tag == Tag.PATH_WRITE;
    }

    public static DeleteError pathWrite(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new DeleteError().withTagAndPathWrite(Tag.PATH_WRITE, value);
    }

    public WriteError getPathWriteValue() {
        if (this._tag != Tag.PATH_WRITE) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH_WRITE, but was Tag." + this._tag.name());
        }
        return this.pathWriteValue;
    }

    public boolean isTooManyWriteOperations() {
        return this._tag == Tag.TOO_MANY_WRITE_OPERATIONS;
    }

    public boolean isTooManyFiles() {
        return this._tag == Tag.TOO_MANY_FILES;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathLookupValue, this.pathWriteValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DeleteError) {
            DeleteError other = (DeleteError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH_LOOKUP: {
                    return this.pathLookupValue == other.pathLookupValue || this.pathLookupValue.equals(other.pathLookupValue);
                }
                case PATH_WRITE: {
                    return this.pathWriteValue == other.pathWriteValue || this.pathWriteValue.equals(other.pathWriteValue);
                }
                case TOO_MANY_WRITE_OPERATIONS: {
                    return true;
                }
                case TOO_MANY_FILES: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<DeleteError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeleteError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH_LOOKUP: {
                    g2.writeStartObject();
                    this.writeTag("path_lookup", g2);
                    g2.writeFieldName("path_lookup");
                    LookupError.Serializer.INSTANCE.serialize(value.pathLookupValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case PATH_WRITE: {
                    g2.writeStartObject();
                    this.writeTag("path_write", g2);
                    g2.writeFieldName("path_write");
                    WriteError.Serializer.INSTANCE.serialize(value.pathWriteValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case TOO_MANY_WRITE_OPERATIONS: {
                    g2.writeString("too_many_write_operations");
                    break;
                }
                case TOO_MANY_FILES: {
                    g2.writeString("too_many_files");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public DeleteError deserialize(JsonParser p) throws IOException, JsonParseException {
            DeleteError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path_lookup".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path_lookup", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = DeleteError.pathLookup(fieldValue);
            } else if ("path_write".equals(tag)) {
                WriteError fieldValue = null;
                Serializer.expectField("path_write", p);
                fieldValue = WriteError.Serializer.INSTANCE.deserialize(p);
                value = DeleteError.pathWrite(fieldValue);
            } else {
                value = "too_many_write_operations".equals(tag) ? TOO_MANY_WRITE_OPERATIONS : ("too_many_files".equals(tag) ? TOO_MANY_FILES : OTHER);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH_LOOKUP,
        PATH_WRITE,
        TOO_MANY_WRITE_OPERATIONS,
        TOO_MANY_FILES,
        OTHER;

    }
}

