/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class LockResult {
    protected final String fileId;
    protected final long expiresAt;

    public LockResult(String fileId, long expiresAt) {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        this.fileId = fileId;
        this.expiresAt = expiresAt;
    }

    public LockResult() {
        this("\"\"", 0L);
    }

    public String getFileId() {
        return this.fileId;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileId, this.expiresAt});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LockResult other = (LockResult)obj;
            return (this.fileId == other.fileId || this.fileId.equals(other.fileId)) && this.expiresAt == other.expiresAt;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LockResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LockResult value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("file_id");
            StoneSerializers.string().serialize(value.fileId, g2);
            g2.writeFieldName("expires_at");
            StoneSerializers.int64().serialize((Long)value.expiresAt, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public LockResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_expiresAt;
            String f_fileId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_fileId = "\"\"";
                f_expiresAt = 0L;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_id".equals(field)) {
                        f_fileId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("expires_at".equals(field)) {
                        f_expiresAt = StoneSerializers.int64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LockResult value = new LockResult(f_fileId, f_expiresAt);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String fileId = "\"\"";
        protected long expiresAt = 0L;

        protected Builder() {
        }

        public Builder withFileId(String fileId) {
            this.fileId = fileId != null ? fileId : "\"\"";
            return this;
        }

        public Builder withExpiresAt(Long expiresAt) {
            this.expiresAt = expiresAt != null ? expiresAt : 0L;
            return this;
        }

        public LockResult build() {
            return new LockResult(this.fileId, this.expiresAt);
        }
    }
}

