/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class LangUtil {
    public static RuntimeException mkAssert(String messagePrefix, Throwable cause) {
        RuntimeException ae = new RuntimeException(messagePrefix + ": " + cause.getMessage());
        ae.initCause(cause);
        return ae;
    }

    public static AssertionError badType(Object a) {
        String msg = a == null ? "bad type: null" : "bad type: " + a.getClass().getName();
        return new AssertionError((Object)msg);
    }

    public static <T> T[] arrayConcat(T[] a, T[] b) {
        if (a == null) {
            throw new IllegalArgumentException("'a' can't be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("'b' can't be null");
        }
        T[] rn = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, rn, a.length, b.length);
        T[] r = rn;
        return r;
    }

    public static <T> boolean nullableEquals(T a, T b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static int nullableHashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode() + 1;
    }

    public static Date truncateMillis(Date date) {
        if (date != null) {
            long time = date.getTime();
            return new Date(time - time % 1000L);
        }
        return date;
    }

    public static List<Date> truncateMillis(List<Date> dates) {
        if (dates != null) {
            ArrayList<Date> truncated = new ArrayList<Date>(dates.size());
            for (Date date : dates) {
                long time = date.getTime();
                truncated.add(new Date(time - time % 1000L));
            }
            return truncated;
        }
        return dates;
    }
}

