/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class LegalHoldsExportDownloadedDetails {
    protected final String legalHoldId;
    protected final String name;
    protected final String exportName;
    protected final String part;
    protected final String fileName;

    public LegalHoldsExportDownloadedDetails(String legalHoldId, String name, String exportName, String part, String fileName) {
        if (legalHoldId == null) {
            throw new IllegalArgumentException("Required value for 'legalHoldId' is null");
        }
        this.legalHoldId = legalHoldId;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (exportName == null) {
            throw new IllegalArgumentException("Required value for 'exportName' is null");
        }
        this.exportName = exportName;
        this.part = part;
        this.fileName = fileName;
    }

    public LegalHoldsExportDownloadedDetails(String legalHoldId, String name, String exportName) {
        this(legalHoldId, name, exportName, null, null);
    }

    public String getLegalHoldId() {
        return this.legalHoldId;
    }

    public String getName() {
        return this.name;
    }

    public String getExportName() {
        return this.exportName;
    }

    public String getPart() {
        return this.part;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static Builder newBuilder(String legalHoldId, String name, String exportName) {
        return new Builder(legalHoldId, name, exportName);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.legalHoldId, this.name, this.exportName, this.part, this.fileName});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LegalHoldsExportDownloadedDetails other = (LegalHoldsExportDownloadedDetails)obj;
            return !(this.legalHoldId != other.legalHoldId && !this.legalHoldId.equals(other.legalHoldId) || this.name != other.name && !this.name.equals(other.name) || this.exportName != other.exportName && !this.exportName.equals(other.exportName) || this.part != other.part && (this.part == null || !this.part.equals(other.part)) || this.fileName != other.fileName && (this.fileName == null || !this.fileName.equals(other.fileName)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LegalHoldsExportDownloadedDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LegalHoldsExportDownloadedDetails value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("legal_hold_id");
            StoneSerializers.string().serialize(value.legalHoldId, g2);
            g2.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g2);
            g2.writeFieldName("export_name");
            StoneSerializers.string().serialize(value.exportName, g2);
            if (value.part != null) {
                g2.writeFieldName("part");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.part, g2);
            }
            if (value.fileName != null) {
                g2.writeFieldName("file_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fileName, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public LegalHoldsExportDownloadedDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_fileName;
            String f_part;
            String f_exportName;
            String f_name;
            String f_legalHoldId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_legalHoldId = null;
                f_name = null;
                f_exportName = null;
                f_part = null;
                f_fileName = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("legal_hold_id".equals(field)) {
                        f_legalHoldId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("export_name".equals(field)) {
                        f_exportName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("part".equals(field)) {
                        f_part = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("file_name".equals(field)) {
                        f_fileName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_legalHoldId == null) {
                    throw new JsonParseException(p, "Required field \"legal_hold_id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_exportName == null) {
                    throw new JsonParseException(p, "Required field \"export_name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LegalHoldsExportDownloadedDetails value = new LegalHoldsExportDownloadedDetails(f_legalHoldId, f_name, f_exportName, f_part, f_fileName);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String legalHoldId;
        protected final String name;
        protected final String exportName;
        protected String part;
        protected String fileName;

        protected Builder(String legalHoldId, String name, String exportName) {
            if (legalHoldId == null) {
                throw new IllegalArgumentException("Required value for 'legalHoldId' is null");
            }
            this.legalHoldId = legalHoldId;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (exportName == null) {
                throw new IllegalArgumentException("Required value for 'exportName' is null");
            }
            this.exportName = exportName;
            this.part = null;
            this.fileName = null;
        }

        public Builder withPart(String part) {
            this.part = part;
            return this;
        }

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public LegalHoldsExportDownloadedDetails build() {
            return new LegalHoldsExportDownloadedDetails(this.legalHoldId, this.name, this.exportName, this.part, this.fileName);
        }
    }
}

