/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.TeamFolderAccessError;
import com.dropbox.core.v2.team.TeamFolderInvalidStatusError;
import com.dropbox.core.v2.team.TeamFolderTeamSharedDropboxError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class TeamFolderRenameError {
    public static final TeamFolderRenameError OTHER = new TeamFolderRenameError().withTag(Tag.OTHER);
    public static final TeamFolderRenameError INVALID_FOLDER_NAME = new TeamFolderRenameError().withTag(Tag.INVALID_FOLDER_NAME);
    public static final TeamFolderRenameError FOLDER_NAME_ALREADY_USED = new TeamFolderRenameError().withTag(Tag.FOLDER_NAME_ALREADY_USED);
    public static final TeamFolderRenameError FOLDER_NAME_RESERVED = new TeamFolderRenameError().withTag(Tag.FOLDER_NAME_RESERVED);
    private Tag _tag;
    private TeamFolderAccessError accessErrorValue;
    private TeamFolderInvalidStatusError statusErrorValue;
    private TeamFolderTeamSharedDropboxError teamSharedDropboxErrorValue;

    private TeamFolderRenameError() {
    }

    private TeamFolderRenameError withTag(Tag _tag) {
        TeamFolderRenameError result = new TeamFolderRenameError();
        result._tag = _tag;
        return result;
    }

    private TeamFolderRenameError withTagAndAccessError(Tag _tag, TeamFolderAccessError accessErrorValue) {
        TeamFolderRenameError result = new TeamFolderRenameError();
        result._tag = _tag;
        result.accessErrorValue = accessErrorValue;
        return result;
    }

    private TeamFolderRenameError withTagAndStatusError(Tag _tag, TeamFolderInvalidStatusError statusErrorValue) {
        TeamFolderRenameError result = new TeamFolderRenameError();
        result._tag = _tag;
        result.statusErrorValue = statusErrorValue;
        return result;
    }

    private TeamFolderRenameError withTagAndTeamSharedDropboxError(Tag _tag, TeamFolderTeamSharedDropboxError teamSharedDropboxErrorValue) {
        TeamFolderRenameError result = new TeamFolderRenameError();
        result._tag = _tag;
        result.teamSharedDropboxErrorValue = teamSharedDropboxErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static TeamFolderRenameError accessError(TeamFolderAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TeamFolderRenameError().withTagAndAccessError(Tag.ACCESS_ERROR, value);
    }

    public TeamFolderAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isStatusError() {
        return this._tag == Tag.STATUS_ERROR;
    }

    public static TeamFolderRenameError statusError(TeamFolderInvalidStatusError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TeamFolderRenameError().withTagAndStatusError(Tag.STATUS_ERROR, value);
    }

    public TeamFolderInvalidStatusError getStatusErrorValue() {
        if (this._tag != Tag.STATUS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.STATUS_ERROR, but was Tag." + this._tag.name());
        }
        return this.statusErrorValue;
    }

    public boolean isTeamSharedDropboxError() {
        return this._tag == Tag.TEAM_SHARED_DROPBOX_ERROR;
    }

    public static TeamFolderRenameError teamSharedDropboxError(TeamFolderTeamSharedDropboxError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TeamFolderRenameError().withTagAndTeamSharedDropboxError(Tag.TEAM_SHARED_DROPBOX_ERROR, value);
    }

    public TeamFolderTeamSharedDropboxError getTeamSharedDropboxErrorValue() {
        if (this._tag != Tag.TEAM_SHARED_DROPBOX_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM_SHARED_DROPBOX_ERROR, but was Tag." + this._tag.name());
        }
        return this.teamSharedDropboxErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isInvalidFolderName() {
        return this._tag == Tag.INVALID_FOLDER_NAME;
    }

    public boolean isFolderNameAlreadyUsed() {
        return this._tag == Tag.FOLDER_NAME_ALREADY_USED;
    }

    public boolean isFolderNameReserved() {
        return this._tag == Tag.FOLDER_NAME_RESERVED;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.accessErrorValue, this.statusErrorValue, this.teamSharedDropboxErrorValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TeamFolderRenameError) {
            TeamFolderRenameError other = (TeamFolderRenameError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case STATUS_ERROR: {
                    return this.statusErrorValue == other.statusErrorValue || this.statusErrorValue.equals((Object)other.statusErrorValue);
                }
                case TEAM_SHARED_DROPBOX_ERROR: {
                    return this.teamSharedDropboxErrorValue == other.teamSharedDropboxErrorValue || this.teamSharedDropboxErrorValue.equals((Object)other.teamSharedDropboxErrorValue);
                }
                case OTHER: {
                    return true;
                }
                case INVALID_FOLDER_NAME: {
                    return true;
                }
                case FOLDER_NAME_ALREADY_USED: {
                    return true;
                }
                case FOLDER_NAME_RESERVED: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<TeamFolderRenameError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamFolderRenameError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ACCESS_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("access_error", g2);
                    g2.writeFieldName("access_error");
                    TeamFolderAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case STATUS_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("status_error", g2);
                    g2.writeFieldName("status_error");
                    TeamFolderInvalidStatusError.Serializer.INSTANCE.serialize(value.statusErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case TEAM_SHARED_DROPBOX_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("team_shared_dropbox_error", g2);
                    g2.writeFieldName("team_shared_dropbox_error");
                    TeamFolderTeamSharedDropboxError.Serializer.INSTANCE.serialize(value.teamSharedDropboxErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case OTHER: {
                    g2.writeString("other");
                    break;
                }
                case INVALID_FOLDER_NAME: {
                    g2.writeString("invalid_folder_name");
                    break;
                }
                case FOLDER_NAME_ALREADY_USED: {
                    g2.writeString("folder_name_already_used");
                    break;
                }
                case FOLDER_NAME_RESERVED: {
                    g2.writeString("folder_name_reserved");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public TeamFolderRenameError deserialize(JsonParser p) throws IOException, JsonParseException {
            TeamFolderRenameError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("access_error".equals(tag)) {
                TeamFolderAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = TeamFolderAccessError.Serializer.INSTANCE.deserialize(p);
                value = TeamFolderRenameError.accessError(fieldValue);
            } else if ("status_error".equals(tag)) {
                TeamFolderInvalidStatusError fieldValue = null;
                Serializer.expectField("status_error", p);
                fieldValue = TeamFolderInvalidStatusError.Serializer.INSTANCE.deserialize(p);
                value = TeamFolderRenameError.statusError(fieldValue);
            } else if ("team_shared_dropbox_error".equals(tag)) {
                TeamFolderTeamSharedDropboxError fieldValue = null;
                Serializer.expectField("team_shared_dropbox_error", p);
                fieldValue = TeamFolderTeamSharedDropboxError.Serializer.INSTANCE.deserialize(p);
                value = TeamFolderRenameError.teamSharedDropboxError(fieldValue);
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("invalid_folder_name".equals(tag)) {
                value = INVALID_FOLDER_NAME;
            } else if ("folder_name_already_used".equals(tag)) {
                value = FOLDER_NAME_ALREADY_USED;
            } else if ("folder_name_reserved".equals(tag)) {
                value = FOLDER_NAME_RESERVED;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ACCESS_ERROR,
        STATUS_ERROR,
        TEAM_SHARED_DROPBOX_ERROR,
        OTHER,
        INVALID_FOLDER_NAME,
        FOLDER_NAME_ALREADY_USED,
        FOLDER_NAME_RESERVED;

    }
}

