/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.SyncSettingsError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class TeamFolderCreateError {
    public static final TeamFolderCreateError INVALID_FOLDER_NAME = new TeamFolderCreateError().withTag(Tag.INVALID_FOLDER_NAME);
    public static final TeamFolderCreateError FOLDER_NAME_ALREADY_USED = new TeamFolderCreateError().withTag(Tag.FOLDER_NAME_ALREADY_USED);
    public static final TeamFolderCreateError FOLDER_NAME_RESERVED = new TeamFolderCreateError().withTag(Tag.FOLDER_NAME_RESERVED);
    public static final TeamFolderCreateError OTHER = new TeamFolderCreateError().withTag(Tag.OTHER);
    private Tag _tag;
    private SyncSettingsError syncSettingsErrorValue;

    private TeamFolderCreateError() {
    }

    private TeamFolderCreateError withTag(Tag _tag) {
        TeamFolderCreateError result = new TeamFolderCreateError();
        result._tag = _tag;
        return result;
    }

    private TeamFolderCreateError withTagAndSyncSettingsError(Tag _tag, SyncSettingsError syncSettingsErrorValue) {
        TeamFolderCreateError result = new TeamFolderCreateError();
        result._tag = _tag;
        result.syncSettingsErrorValue = syncSettingsErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInvalidFolderName() {
        return this._tag == Tag.INVALID_FOLDER_NAME;
    }

    public boolean isFolderNameAlreadyUsed() {
        return this._tag == Tag.FOLDER_NAME_ALREADY_USED;
    }

    public boolean isFolderNameReserved() {
        return this._tag == Tag.FOLDER_NAME_RESERVED;
    }

    public boolean isSyncSettingsError() {
        return this._tag == Tag.SYNC_SETTINGS_ERROR;
    }

    public static TeamFolderCreateError syncSettingsError(SyncSettingsError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TeamFolderCreateError().withTagAndSyncSettingsError(Tag.SYNC_SETTINGS_ERROR, value);
    }

    public SyncSettingsError getSyncSettingsErrorValue() {
        if (this._tag != Tag.SYNC_SETTINGS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.SYNC_SETTINGS_ERROR, but was Tag." + this._tag.name());
        }
        return this.syncSettingsErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.syncSettingsErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TeamFolderCreateError) {
            TeamFolderCreateError other = (TeamFolderCreateError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case INVALID_FOLDER_NAME: {
                    return true;
                }
                case FOLDER_NAME_ALREADY_USED: {
                    return true;
                }
                case FOLDER_NAME_RESERVED: {
                    return true;
                }
                case SYNC_SETTINGS_ERROR: {
                    return this.syncSettingsErrorValue == other.syncSettingsErrorValue || this.syncSettingsErrorValue.equals(other.syncSettingsErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<TeamFolderCreateError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamFolderCreateError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case INVALID_FOLDER_NAME: {
                    g2.writeString("invalid_folder_name");
                    break;
                }
                case FOLDER_NAME_ALREADY_USED: {
                    g2.writeString("folder_name_already_used");
                    break;
                }
                case FOLDER_NAME_RESERVED: {
                    g2.writeString("folder_name_reserved");
                    break;
                }
                case SYNC_SETTINGS_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("sync_settings_error", g2);
                    g2.writeFieldName("sync_settings_error");
                    SyncSettingsError.Serializer.INSTANCE.serialize(value.syncSettingsErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public TeamFolderCreateError deserialize(JsonParser p) throws IOException, JsonParseException {
            TeamFolderCreateError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("invalid_folder_name".equals(tag)) {
                value = INVALID_FOLDER_NAME;
            } else if ("folder_name_already_used".equals(tag)) {
                value = FOLDER_NAME_ALREADY_USED;
            } else if ("folder_name_reserved".equals(tag)) {
                value = FOLDER_NAME_RESERVED;
            } else if ("sync_settings_error".equals(tag)) {
                SyncSettingsError fieldValue = null;
                Serializer.expectField("sync_settings_error", p);
                fieldValue = SyncSettingsError.Serializer.INSTANCE.deserialize(p);
                value = TeamFolderCreateError.syncSettingsError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        INVALID_FOLDER_NAME,
        FOLDER_NAME_ALREADY_USED,
        FOLDER_NAME_RESERVED,
        SYNC_SETTINGS_ERROR,
        OTHER;

    }
}

