/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.common;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class PathRoot {
    public static final PathRoot HOME = new PathRoot().withTag(Tag.HOME);
    public static final PathRoot OTHER = new PathRoot().withTag(Tag.OTHER);
    private Tag _tag;
    private String rootValue;
    private String namespaceIdValue;

    private PathRoot() {
    }

    private PathRoot withTag(Tag _tag) {
        PathRoot result = new PathRoot();
        result._tag = _tag;
        return result;
    }

    private PathRoot withTagAndRoot(Tag _tag, String rootValue) {
        PathRoot result = new PathRoot();
        result._tag = _tag;
        result.rootValue = rootValue;
        return result;
    }

    private PathRoot withTagAndNamespaceId(Tag _tag, String namespaceIdValue) {
        PathRoot result = new PathRoot();
        result._tag = _tag;
        result.namespaceIdValue = namespaceIdValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isHome() {
        return this._tag == Tag.HOME;
    }

    public boolean isRoot() {
        return this._tag == Tag.ROOT;
    }

    public static PathRoot root(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new PathRoot().withTagAndRoot(Tag.ROOT, value);
    }

    public String getRootValue() {
        if (this._tag != Tag.ROOT) {
            throw new IllegalStateException("Invalid tag: required Tag.ROOT, but was Tag." + this._tag.name());
        }
        return this.rootValue;
    }

    public boolean isNamespaceId() {
        return this._tag == Tag.NAMESPACE_ID;
    }

    public static PathRoot namespaceId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new PathRoot().withTagAndNamespaceId(Tag.NAMESPACE_ID, value);
    }

    public String getNamespaceIdValue() {
        if (this._tag != Tag.NAMESPACE_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.NAMESPACE_ID, but was Tag." + this._tag.name());
        }
        return this.namespaceIdValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.rootValue, this.namespaceIdValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PathRoot) {
            PathRoot other = (PathRoot)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case HOME: {
                    return true;
                }
                case ROOT: {
                    return this.rootValue == other.rootValue || this.rootValue.equals(other.rootValue);
                }
                case NAMESPACE_ID: {
                    return this.namespaceIdValue == other.namespaceIdValue || this.namespaceIdValue.equals(other.namespaceIdValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<PathRoot> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(PathRoot value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case HOME: {
                    g2.writeString("home");
                    break;
                }
                case ROOT: {
                    g2.writeStartObject();
                    this.writeTag("root", g2);
                    g2.writeFieldName("root");
                    StoneSerializers.string().serialize(value.rootValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case NAMESPACE_ID: {
                    g2.writeStartObject();
                    this.writeTag("namespace_id", g2);
                    g2.writeFieldName("namespace_id");
                    StoneSerializers.string().serialize(value.namespaceIdValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public PathRoot deserialize(JsonParser p) throws IOException, JsonParseException {
            PathRoot value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("home".equals(tag)) {
                value = HOME;
            } else if ("root".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("root", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = PathRoot.root(fieldValue);
            } else if ("namespace_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("namespace_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = PathRoot.namespaceId(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        HOME,
        ROOT,
        NAMESPACE_ID,
        OTHER;

    }
}

