/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessInheritance;
import com.dropbox.core.v2.sharing.AclUpdatePolicy;
import com.dropbox.core.v2.sharing.FolderAction;
import com.dropbox.core.v2.sharing.LinkSettings;
import com.dropbox.core.v2.sharing.MemberPolicy;
import com.dropbox.core.v2.sharing.ShareFolderArgBase;
import com.dropbox.core.v2.sharing.SharedLinkPolicy;
import com.dropbox.core.v2.sharing.ViewerInfoPolicy;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class ShareFolderArg
extends ShareFolderArgBase {
    protected final List<FolderAction> actions;
    protected final LinkSettings linkSettings;

    public ShareFolderArg(String path, AclUpdatePolicy aclUpdatePolicy, boolean forceAsync, MemberPolicy memberPolicy, SharedLinkPolicy sharedLinkPolicy, ViewerInfoPolicy viewerInfoPolicy, AccessInheritance accessInheritance, List<FolderAction> actions, LinkSettings linkSettings) {
        super(path, aclUpdatePolicy, forceAsync, memberPolicy, sharedLinkPolicy, viewerInfoPolicy, accessInheritance);
        if (actions != null) {
            for (FolderAction x : actions) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'actions' is null");
            }
        }
        this.actions = actions;
        this.linkSettings = linkSettings;
    }

    public ShareFolderArg(String path) {
        this(path, null, false, null, null, null, AccessInheritance.INHERIT, null, null);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public AclUpdatePolicy getAclUpdatePolicy() {
        return this.aclUpdatePolicy;
    }

    @Override
    public boolean getForceAsync() {
        return this.forceAsync;
    }

    @Override
    public MemberPolicy getMemberPolicy() {
        return this.memberPolicy;
    }

    @Override
    public SharedLinkPolicy getSharedLinkPolicy() {
        return this.sharedLinkPolicy;
    }

    @Override
    public ViewerInfoPolicy getViewerInfoPolicy() {
        return this.viewerInfoPolicy;
    }

    @Override
    public AccessInheritance getAccessInheritance() {
        return this.accessInheritance;
    }

    public List<FolderAction> getActions() {
        return this.actions;
    }

    public LinkSettings getLinkSettings() {
        return this.linkSettings;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.actions, this.linkSettings});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ShareFolderArg other = (ShareFolderArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.aclUpdatePolicy != other.aclUpdatePolicy && (this.aclUpdatePolicy == null || !this.aclUpdatePolicy.equals((Object)other.aclUpdatePolicy)) || this.forceAsync != other.forceAsync || this.memberPolicy != other.memberPolicy && (this.memberPolicy == null || !this.memberPolicy.equals((Object)other.memberPolicy)) || this.sharedLinkPolicy != other.sharedLinkPolicy && (this.sharedLinkPolicy == null || !this.sharedLinkPolicy.equals((Object)other.sharedLinkPolicy)) || this.viewerInfoPolicy != other.viewerInfoPolicy && (this.viewerInfoPolicy == null || !this.viewerInfoPolicy.equals((Object)other.viewerInfoPolicy)) || this.accessInheritance != other.accessInheritance && !this.accessInheritance.equals((Object)other.accessInheritance) || this.actions != other.actions && (this.actions == null || !this.actions.equals(other.actions)) || this.linkSettings != other.linkSettings && (this.linkSettings == null || !this.linkSettings.equals(other.linkSettings)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ShareFolderArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ShareFolderArg value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g2);
            if (value.aclUpdatePolicy != null) {
                g2.writeFieldName("acl_update_policy");
                StoneSerializers.nullable(AclUpdatePolicy.Serializer.INSTANCE).serialize(value.aclUpdatePolicy, g2);
            }
            g2.writeFieldName("force_async");
            StoneSerializers.boolean_().serialize((Boolean)value.forceAsync, g2);
            if (value.memberPolicy != null) {
                g2.writeFieldName("member_policy");
                StoneSerializers.nullable(MemberPolicy.Serializer.INSTANCE).serialize(value.memberPolicy, g2);
            }
            if (value.sharedLinkPolicy != null) {
                g2.writeFieldName("shared_link_policy");
                StoneSerializers.nullable(SharedLinkPolicy.Serializer.INSTANCE).serialize(value.sharedLinkPolicy, g2);
            }
            if (value.viewerInfoPolicy != null) {
                g2.writeFieldName("viewer_info_policy");
                StoneSerializers.nullable(ViewerInfoPolicy.Serializer.INSTANCE).serialize(value.viewerInfoPolicy, g2);
            }
            g2.writeFieldName("access_inheritance");
            AccessInheritance.Serializer.INSTANCE.serialize(value.accessInheritance, g2);
            if (value.actions != null) {
                g2.writeFieldName("actions");
                StoneSerializers.nullable(StoneSerializers.list(FolderAction.Serializer.INSTANCE)).serialize(value.actions, g2);
            }
            if (value.linkSettings != null) {
                g2.writeFieldName("link_settings");
                StoneSerializers.nullableStruct(LinkSettings.Serializer.INSTANCE).serialize(value.linkSettings, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public ShareFolderArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            LinkSettings f_linkSettings;
            List<FolderAction> f_actions;
            AccessInheritance f_accessInheritance;
            ViewerInfoPolicy f_viewerInfoPolicy;
            SharedLinkPolicy f_sharedLinkPolicy;
            MemberPolicy f_memberPolicy;
            Boolean f_forceAsync;
            AclUpdatePolicy f_aclUpdatePolicy;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_aclUpdatePolicy = null;
                f_forceAsync = false;
                f_memberPolicy = null;
                f_sharedLinkPolicy = null;
                f_viewerInfoPolicy = null;
                f_accessInheritance = AccessInheritance.INHERIT;
                f_actions = null;
                f_linkSettings = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("acl_update_policy".equals(field)) {
                        f_aclUpdatePolicy = StoneSerializers.nullable(AclUpdatePolicy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("force_async".equals(field)) {
                        f_forceAsync = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("member_policy".equals(field)) {
                        f_memberPolicy = StoneSerializers.nullable(MemberPolicy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("shared_link_policy".equals(field)) {
                        f_sharedLinkPolicy = StoneSerializers.nullable(SharedLinkPolicy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("viewer_info_policy".equals(field)) {
                        f_viewerInfoPolicy = StoneSerializers.nullable(ViewerInfoPolicy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("access_inheritance".equals(field)) {
                        f_accessInheritance = AccessInheritance.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("actions".equals(field)) {
                        f_actions = StoneSerializers.nullable(StoneSerializers.list(FolderAction.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("link_settings".equals(field)) {
                        f_linkSettings = StoneSerializers.nullableStruct(LinkSettings.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ShareFolderArg value = new ShareFolderArg(f_path, f_aclUpdatePolicy, f_forceAsync, f_memberPolicy, f_sharedLinkPolicy, f_viewerInfoPolicy, f_accessInheritance, f_actions, f_linkSettings);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends ShareFolderArgBase.Builder {
        protected List<FolderAction> actions = null;
        protected LinkSettings linkSettings = null;

        protected Builder(String path) {
            super(path);
        }

        public Builder withActions(List<FolderAction> actions) {
            if (actions != null) {
                for (FolderAction x : actions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'actions' is null");
                }
            }
            this.actions = actions;
            return this;
        }

        public Builder withLinkSettings(LinkSettings linkSettings) {
            this.linkSettings = linkSettings;
            return this;
        }

        @Override
        public Builder withAclUpdatePolicy(AclUpdatePolicy aclUpdatePolicy) {
            super.withAclUpdatePolicy(aclUpdatePolicy);
            return this;
        }

        @Override
        public Builder withForceAsync(Boolean forceAsync) {
            super.withForceAsync(forceAsync);
            return this;
        }

        @Override
        public Builder withMemberPolicy(MemberPolicy memberPolicy) {
            super.withMemberPolicy(memberPolicy);
            return this;
        }

        @Override
        public Builder withSharedLinkPolicy(SharedLinkPolicy sharedLinkPolicy) {
            super.withSharedLinkPolicy(sharedLinkPolicy);
            return this;
        }

        @Override
        public Builder withViewerInfoPolicy(ViewerInfoPolicy viewerInfoPolicy) {
            super.withViewerInfoPolicy(viewerInfoPolicy);
            return this;
        }

        @Override
        public Builder withAccessInheritance(AccessInheritance accessInheritance) {
            super.withAccessInheritance(accessInheritance);
            return this;
        }

        @Override
        public ShareFolderArg build() {
            return new ShareFolderArg(this.path, this.aclUpdatePolicy, this.forceAsync, this.memberPolicy, this.sharedLinkPolicy, this.viewerInfoPolicy, this.accessInheritance, this.actions, this.linkSettings);
        }
    }
}

