/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.MemberPermission;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class MembershipInfo {
    protected final AccessLevel accessType;
    protected final List<MemberPermission> permissions;
    protected final String initials;
    protected final boolean isInherited;

    public MembershipInfo(AccessLevel accessType, List<MemberPermission> permissions, String initials, boolean isInherited) {
        if (accessType == null) {
            throw new IllegalArgumentException("Required value for 'accessType' is null");
        }
        this.accessType = accessType;
        if (permissions != null) {
            for (MemberPermission x : permissions) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'permissions' is null");
            }
        }
        this.permissions = permissions;
        this.initials = initials;
        this.isInherited = isInherited;
    }

    public MembershipInfo(AccessLevel accessType) {
        this(accessType, null, null, false);
    }

    public AccessLevel getAccessType() {
        return this.accessType;
    }

    public List<MemberPermission> getPermissions() {
        return this.permissions;
    }

    public String getInitials() {
        return this.initials;
    }

    public boolean getIsInherited() {
        return this.isInherited;
    }

    public static Builder newBuilder(AccessLevel accessType) {
        return new Builder(accessType);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accessType, this.permissions, this.initials, this.isInherited});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MembershipInfo other = (MembershipInfo)obj;
            return (this.accessType == other.accessType || this.accessType.equals((Object)other.accessType)) && (this.permissions == other.permissions || this.permissions != null && this.permissions.equals(other.permissions)) && (this.initials == other.initials || this.initials != null && this.initials.equals(other.initials)) && this.isInherited == other.isInherited;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    private static class Serializer
    extends StructSerializer<MembershipInfo> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void serialize(MembershipInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("access_type");
            AccessLevel.Serializer.INSTANCE.serialize(value.accessType, g2);
            if (value.permissions != null) {
                g2.writeFieldName("permissions");
                StoneSerializers.nullable(StoneSerializers.list(MemberPermission.Serializer.INSTANCE)).serialize(value.permissions, g2);
            }
            if (value.initials != null) {
                g2.writeFieldName("initials");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.initials, g2);
            }
            g2.writeFieldName("is_inherited");
            StoneSerializers.boolean_().serialize((Boolean)value.isInherited, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public MembershipInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_isInherited;
            String f_initials;
            List<MemberPermission> f_permissions;
            AccessLevel f_accessType;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accessType = null;
                f_permissions = null;
                f_initials = null;
                f_isInherited = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("access_type".equals(field)) {
                        f_accessType = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("permissions".equals(field)) {
                        f_permissions = StoneSerializers.nullable(StoneSerializers.list(MemberPermission.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("initials".equals(field)) {
                        f_initials = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("is_inherited".equals(field)) {
                        f_isInherited = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accessType == null) {
                    throw new JsonParseException(p, "Required field \"access_type\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MembershipInfo value = new MembershipInfo(f_accessType, f_permissions, f_initials, f_isInherited);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final AccessLevel accessType;
        protected List<MemberPermission> permissions;
        protected String initials;
        protected boolean isInherited;

        protected Builder(AccessLevel accessType) {
            if (accessType == null) {
                throw new IllegalArgumentException("Required value for 'accessType' is null");
            }
            this.accessType = accessType;
            this.permissions = null;
            this.initials = null;
            this.isInherited = false;
        }

        public Builder withPermissions(List<MemberPermission> permissions) {
            if (permissions != null) {
                for (MemberPermission x : permissions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'permissions' is null");
                }
            }
            this.permissions = permissions;
            return this;
        }

        public Builder withInitials(String initials) {
            this.initials = initials;
            return this;
        }

        public Builder withIsInherited(Boolean isInherited) {
            this.isInherited = isInherited != null ? isInherited : false;
            return this;
        }

        public MembershipInfo build() {
            return new MembershipInfo(this.accessType, this.permissions, this.initials, this.isInherited);
        }
    }
}

