/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.Cursor;
import com.dropbox.core.v2.sharing.InviteeInfo;
import com.dropbox.core.v2.sharing.UserInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ListUsersOnFolderResponse {
    protected final List<InviteeInfo> invitees;
    protected final List<UserInfo> users;
    protected final Cursor cursor;
    protected final boolean hasMore;

    public ListUsersOnFolderResponse(List<InviteeInfo> invitees, List<UserInfo> users, Cursor cursor, boolean hasMore) {
        if (invitees == null) {
            throw new IllegalArgumentException("Required value for 'invitees' is null");
        }
        for (InviteeInfo inviteeInfo : invitees) {
            if (inviteeInfo != null) continue;
            throw new IllegalArgumentException("An item in list 'invitees' is null");
        }
        this.invitees = invitees;
        if (users == null) {
            throw new IllegalArgumentException("Required value for 'users' is null");
        }
        for (UserInfo userInfo : users) {
            if (userInfo != null) continue;
            throw new IllegalArgumentException("An item in list 'users' is null");
        }
        this.users = users;
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    public List<InviteeInfo> getInvitees() {
        return this.invitees;
    }

    public List<UserInfo> getUsers() {
        return this.users;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.invitees, this.users, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListUsersOnFolderResponse other = (ListUsersOnFolderResponse)obj;
            return !(this.invitees != other.invitees && !this.invitees.equals(other.invitees) || this.users != other.users && !this.users.equals(other.users) || this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.hasMore != other.hasMore);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListUsersOnFolderResponse> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListUsersOnFolderResponse value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("invitees");
            StoneSerializers.list(InviteeInfo.Serializer.INSTANCE).serialize(value.invitees, g2);
            g2.writeFieldName("users");
            StoneSerializers.list(UserInfo.Serializer.INSTANCE).serialize(value.users, g2);
            g2.writeFieldName("cursor");
            Cursor.Serializer.INSTANCE.serialize(value.cursor, g2);
            g2.writeFieldName("has_more");
            StoneSerializers.boolean_().serialize((Boolean)value.hasMore, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public ListUsersOnFolderResponse deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_hasMore;
            Cursor f_cursor;
            List<UserInfo> f_users;
            List<InviteeInfo> f_invitees;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_invitees = null;
                f_users = null;
                f_cursor = null;
                f_hasMore = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("invitees".equals(field)) {
                        f_invitees = StoneSerializers.list(InviteeInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("users".equals(field)) {
                        f_users = StoneSerializers.list(UserInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = (Cursor)Cursor.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("has_more".equals(field)) {
                        f_hasMore = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_invitees == null) {
                    throw new JsonParseException(p, "Required field \"invitees\" missing.");
                }
                if (f_users == null) {
                    throw new JsonParseException(p, "Required field \"users\" missing.");
                }
                if (f_cursor == null) {
                    throw new JsonParseException(p, "Required field \"cursor\" missing.");
                }
                if (f_hasMore == null) {
                    throw new JsonParseException(p, "Required field \"has_more\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListUsersOnFolderResponse value = new ListUsersOnFolderResponse(f_invitees, f_users, f_cursor, f_hasMore);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

