/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.SearchMatchFieldOptions;
import com.dropbox.core.v2.files.SearchOptions;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class SearchV2Arg {
    protected final String query;
    protected final SearchOptions options;
    protected final SearchMatchFieldOptions matchFieldOptions;
    protected final boolean includeHighlights;

    public SearchV2Arg(String query, SearchOptions options, SearchMatchFieldOptions matchFieldOptions, boolean includeHighlights) {
        if (query == null) {
            throw new IllegalArgumentException("Required value for 'query' is null");
        }
        this.query = query;
        this.options = options;
        this.matchFieldOptions = matchFieldOptions;
        this.includeHighlights = includeHighlights;
    }

    public SearchV2Arg(String query) {
        this(query, null, null, false);
    }

    public String getQuery() {
        return this.query;
    }

    public SearchOptions getOptions() {
        return this.options;
    }

    public SearchMatchFieldOptions getMatchFieldOptions() {
        return this.matchFieldOptions;
    }

    public boolean getIncludeHighlights() {
        return this.includeHighlights;
    }

    public static Builder newBuilder(String query) {
        return new Builder(query);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.query, this.options, this.matchFieldOptions, this.includeHighlights});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SearchV2Arg other = (SearchV2Arg)obj;
            return (this.query == other.query || this.query.equals(other.query)) && (this.options == other.options || this.options != null && this.options.equals(other.options)) && (this.matchFieldOptions == other.matchFieldOptions || this.matchFieldOptions != null && this.matchFieldOptions.equals(other.matchFieldOptions)) && this.includeHighlights == other.includeHighlights;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SearchV2Arg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SearchV2Arg value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("query");
            StoneSerializers.string().serialize(value.query, g2);
            if (value.options != null) {
                g2.writeFieldName("options");
                StoneSerializers.nullableStruct(SearchOptions.Serializer.INSTANCE).serialize(value.options, g2);
            }
            if (value.matchFieldOptions != null) {
                g2.writeFieldName("match_field_options");
                StoneSerializers.nullableStruct(SearchMatchFieldOptions.Serializer.INSTANCE).serialize(value.matchFieldOptions, g2);
            }
            g2.writeFieldName("include_highlights");
            StoneSerializers.boolean_().serialize((Boolean)value.includeHighlights, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public SearchV2Arg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_includeHighlights;
            SearchMatchFieldOptions f_matchFieldOptions;
            SearchOptions f_options;
            String f_query;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_query = null;
                f_options = null;
                f_matchFieldOptions = null;
                f_includeHighlights = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("query".equals(field)) {
                        f_query = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("options".equals(field)) {
                        f_options = StoneSerializers.nullableStruct(SearchOptions.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("match_field_options".equals(field)) {
                        f_matchFieldOptions = StoneSerializers.nullableStruct(SearchMatchFieldOptions.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("include_highlights".equals(field)) {
                        f_includeHighlights = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_query == null) {
                    throw new JsonParseException(p, "Required field \"query\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SearchV2Arg value = new SearchV2Arg(f_query, f_options, f_matchFieldOptions, f_includeHighlights);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String query;
        protected SearchOptions options;
        protected SearchMatchFieldOptions matchFieldOptions;
        protected boolean includeHighlights;

        protected Builder(String query) {
            if (query == null) {
                throw new IllegalArgumentException("Required value for 'query' is null");
            }
            this.query = query;
            this.options = null;
            this.matchFieldOptions = null;
            this.includeHighlights = false;
        }

        public Builder withOptions(SearchOptions options) {
            this.options = options;
            return this;
        }

        public Builder withMatchFieldOptions(SearchMatchFieldOptions matchFieldOptions) {
            this.matchFieldOptions = matchFieldOptions;
            return this;
        }

        public Builder withIncludeHighlights(Boolean includeHighlights) {
            this.includeHighlights = includeHighlights != null ? includeHighlights : false;
            return this;
        }

        public SearchV2Arg build() {
            return new SearchV2Arg(this.query, this.options, this.matchFieldOptions, this.includeHighlights);
        }
    }
}

