/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.util;

import java.util.ArrayList;
import java.util.Objects;

public class StringUtils {
    public static void replaceAll(StringBuilder builder, String from, String to) {
        int index;
        while ((index = builder.indexOf(from)) != -1) {
            builder.replace(index, index + from.length(), to);
        }
    }

    public static String replaceFirst(String text, String searchString, String replacement) {
        return org.apache.commons.lang3.StringUtils.replaceOnce(text, searchString, replacement);
    }

    public static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)(.*)" + regex, "$1" + replacement);
    }

    public static String[] split(String string, int length, String split) {
        Objects.requireNonNull(string);
        if (string.length() == 0) {
            return new String[0];
        }
        if (string.length() == 1) {
            return new String[]{string};
        }
        if (string.length() <= length) {
            return new String[]{string};
        }
        ArrayList<String> strings = new ArrayList<String>();
        while (string.length() > length) {
            String current = string.substring(0, length + split.length());
            int index = current.lastIndexOf(split);
            if (index == -1) {
                throw new UnsupportedOperationException("One or more substrings were too long!");
            }
            String substring = current.substring(0, index);
            strings.add(substring);
            string = StringUtils.replaceFirst(string, substring + split, "");
        }
        return strings.toArray(new String[0]);
    }

    public static String toPrettyString(Iterable<?> collection) {
        StringBuilder string = new StringBuilder();
        for (Object object : collection) {
            string.append(Objects.toString(object)).append(", ");
        }
        return StringUtils.replaceLast(string.toString(), ", ", "");
    }
}

