/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.launcher;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static final String[] JAVA_ARGS = new String[]{"-Xmx250m"};
    private static final int UPDATE_RETURN_VALUE = 101;
    private static final Path BOT_FILE = Paths.get("Bot-all.jar", new String[0]);
    private static final Path BOT_UPDATE = Paths.get("Bot_Update.jar", new String[0]);
    private static final long SLEEP_TIMEOUT = 1000L;
    private static final int MAX_ATTEMPTS = 10;
    private static final Logger LOG = LoggerFactory.getLogger(Launcher.class);

    public static void main(String[] args) {
        int returnValue;
        if (!Files.exists(BOT_FILE, new LinkOption[0])) {
            LOG.warn("Bot file not found. aborting ({})", (Object)BOT_FILE.toAbsolutePath().toString());
            return;
        }
        if (!Files.isWritable(BOT_FILE)) {
            LOG.warn("Bot might still be running. aborting");
            return;
        }
        if (Files.exists(BOT_UPDATE, new LinkOption[0]) && !Launcher.update()) {
            LOG.warn("Found update file but could not update... starting up anyway");
        }
        do {
            Process p;
            if ((p = Launcher.startBot()) == null) {
                return;
            }
            try {
                returnValue = p.waitFor();
                if (returnValue == 101 && Files.exists(BOT_UPDATE, new LinkOption[0]) && !Launcher.update()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                LOG.error("Could not wait for bot to exit", e);
                return;
            }
        } while (returnValue == 101);
        LOG.info("Bot shut down with code {}", (Object)returnValue);
    }

    private static boolean update() {
        LOG.info("Updating Bot after file is free for writing");
        return Launcher.update(0);
    }

    private static boolean update(int attempt) {
        if (attempt >= 10) {
            LOG.error("Maximum attempts to update reached. aborting");
            return false;
        }
        try {
            LOG.debug("Waiting one second for bot to fully close");
            Thread.sleep(1000L);
            if (!Files.isWritable(BOT_FILE)) {
                LOG.debug("Bot file not yet writable, trying later");
                return Launcher.update(attempt + 1);
            }
            LOG.debug("Moving update file to bot file");
            Files.deleteIfExists(BOT_FILE);
            Files.move(BOT_UPDATE, BOT_FILE, new CopyOption[0]);
            return true;
        }
        catch (IOException | InterruptedException e) {
            LOG.error("There was an error moving the update file", e);
            return false;
        }
    }

    private static Process startBot() {
        try {
            LOG.info("Starting bot...");
            return new ProcessBuilder(Launcher.getStartCommand()).inheritIO().start();
        }
        catch (IOException e) {
            LOG.error("Starting bot failed, used start command {}", (Object)Launcher.getStartCommand(), (Object)e);
            return null;
        }
    }

    private static List<String> getStartCommand() {
        ArrayList<String> command = new ArrayList<String>(JAVA_ARGS.length + 2);
        command.add("java");
        command.addAll(Arrays.asList(JAVA_ARGS));
        command.add("-jar");
        command.add(BOT_FILE.toString());
        return command;
    }
}

