/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck.changelog;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsApi;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsBuild;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsChange;
import com.kantenkugel.discordbot.versioncheck.changelog.ChangelogProvider;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JenkinsChangelogProvider
implements ChangelogProvider {
    private final JenkinsApi jenkins;
    private final String githubUrl;

    public JenkinsChangelogProvider(JenkinsApi jenkins, String githubUrl) {
        this.jenkins = jenkins;
        this.githubUrl = githubUrl.endsWith("/") ? githubUrl : githubUrl + '/';
    }

    @Override
    public String getChangelogUrl() {
        return this.jenkins.getChangesetUrl();
    }

    @Override
    public boolean supportsIndividualLogs() {
        return true;
    }

    @Override
    public ChangelogProvider.Changelog getChangelog(String version) {
        List<ChangelogProvider.Changelog> changelogs = this.getChangelogs(version, version);
        return changelogs.isEmpty() ? null : changelogs.get(0);
    }

    @Override
    public List<ChangelogProvider.Changelog> getChangelogs(String startVersion, String endVersion) {
        int start = JenkinsChangelogProvider.extractBuild(startVersion);
        int end = JenkinsChangelogProvider.extractBuild(endVersion);
        if (start == 0 || end == 0) {
            return Collections.emptyList();
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        ArrayList<ChangelogProvider.Changelog> changelogs = new ArrayList<ChangelogProvider.Changelog>();
        try {
            for (int i = start; i <= end; ++i) {
                JenkinsBuild build = this.jenkins.getBuild(i);
                if (build == null) continue;
                String title = build.status == JenkinsBuild.Status.SUCCESS ? build.artifacts.values().iterator().next().fileNameParts.get(1) : "Build " + build.buildNum + " (failed)";
                List<JenkinsChange> changeSet = build.changes;
                List<String> changes = changeSet.size() > 0 ? this.getChangelog(changeSet) : Collections.singletonList("No git commits assigned");
                changelogs.add(new ChangelogProvider.Changelog(title, changes, build.getUrl()));
            }
        }
        catch (IOException ex) {
            if (ex instanceof SocketTimeoutException) {
                changelogs.add(new ChangelogProvider.Changelog("Jenkins timeout", Collections.singletonList("Jenkins timed out while fetching build(s)")));
            }
            Bot.LOG.warn("Fetching build(s) from jenkins errored in Changelog command", ex);
            changelogs.add(new ChangelogProvider.Changelog("Jenkins error", Collections.singletonList("There was an error fetching from Jenkins")));
        }
        return changelogs;
    }

    private List<String> getChangelog(List<JenkinsChange> changeSet) {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (JenkinsChange item : changeSet) {
            String[] lines = item.commitMsg.split("\n");
            for (int j = 0; j < lines.length; ++j) {
                StringBuilder line = new StringBuilder();
                line.append("[`").append(j == 0 ? item.getShortId() : "`.......`").append("`](").append(this.githubUrl).append("commit/").append(item.commitId).append(")").append(" ").append(lines[j]).append("\n");
                if (builder.length() + line.length() > 1021) {
                    fields.add(builder.toString());
                    builder = new StringBuilder();
                }
                builder.append((CharSequence)line);
            }
        }
        if (builder.length() > 0) {
            fields.add(builder.toString());
        }
        return fields;
    }

    private static int extractBuild(String version) {
        int i = version.lastIndexOf(95);
        try {
            return Math.max(0, Integer.parseInt(version.substring(i + 1)));
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }
}

