/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.kantenkugel.discordbot.graphql.GQLQuery;
import com.kantenkugel.discordbot.graphql.entities.gh.Repository;
import com.kantenkugel.discordbot.versioncheck.VersionChecker;
import java.util.function.Supplier;
import org.json.JSONObject;

public class GithubVersionSupplier
implements Supplier<String> {
    private static final int CHECK_COUNT = 1;
    private static final GQLQuery<Repository> QUERY;
    private final JSONObject variableMap;

    public GithubVersionSupplier(String ownerName, String repoName) {
        this.variableMap = new JSONObject().put("owner", ownerName).put("name", repoName).put("count", 1);
    }

    @Override
    public String get() {
        if (QUERY == null) {
            return null;
        }
        Repository repo = QUERY.execute(this.variableMap);
        if (repo == null || repo.getTags().size() == 0) {
            return null;
        }
        return repo.getTags().get(0).getName();
    }

    static {
        String ghToken = Bot.config.getString("github_token", "");
        if (ghToken.isEmpty()) {
            VersionChecker.LOG.warn("No GH token set up. GithubVersionSupplier will not work");
            QUERY = null;
        } else {
            QUERY = new GQLQuery<Repository>("https://api.github.com/graphql", "Bearer " + ghToken, GQLQuery.readQuery("ghTags"), Repository.class);
        }
    }
}

