/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.RelinquishFolderMembershipError;
import com.dropbox.core.v2.sharing.RemoveFolderMemberError;
import com.dropbox.core.v2.sharing.UnshareFolderError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class JobError {
    public static final JobError OTHER = new JobError().withTag(Tag.OTHER);
    private Tag _tag;
    private UnshareFolderError unshareFolderErrorValue;
    private RemoveFolderMemberError removeFolderMemberErrorValue;
    private RelinquishFolderMembershipError relinquishFolderMembershipErrorValue;

    private JobError() {
    }

    private JobError withTag(Tag _tag) {
        JobError result = new JobError();
        result._tag = _tag;
        return result;
    }

    private JobError withTagAndUnshareFolderError(Tag _tag, UnshareFolderError unshareFolderErrorValue) {
        JobError result = new JobError();
        result._tag = _tag;
        result.unshareFolderErrorValue = unshareFolderErrorValue;
        return result;
    }

    private JobError withTagAndRemoveFolderMemberError(Tag _tag, RemoveFolderMemberError removeFolderMemberErrorValue) {
        JobError result = new JobError();
        result._tag = _tag;
        result.removeFolderMemberErrorValue = removeFolderMemberErrorValue;
        return result;
    }

    private JobError withTagAndRelinquishFolderMembershipError(Tag _tag, RelinquishFolderMembershipError relinquishFolderMembershipErrorValue) {
        JobError result = new JobError();
        result._tag = _tag;
        result.relinquishFolderMembershipErrorValue = relinquishFolderMembershipErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUnshareFolderError() {
        return this._tag == Tag.UNSHARE_FOLDER_ERROR;
    }

    public static JobError unshareFolderError(UnshareFolderError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new JobError().withTagAndUnshareFolderError(Tag.UNSHARE_FOLDER_ERROR, value);
    }

    public UnshareFolderError getUnshareFolderErrorValue() {
        if (this._tag != Tag.UNSHARE_FOLDER_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.UNSHARE_FOLDER_ERROR, but was Tag." + this._tag.name());
        }
        return this.unshareFolderErrorValue;
    }

    public boolean isRemoveFolderMemberError() {
        return this._tag == Tag.REMOVE_FOLDER_MEMBER_ERROR;
    }

    public static JobError removeFolderMemberError(RemoveFolderMemberError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new JobError().withTagAndRemoveFolderMemberError(Tag.REMOVE_FOLDER_MEMBER_ERROR, value);
    }

    public RemoveFolderMemberError getRemoveFolderMemberErrorValue() {
        if (this._tag != Tag.REMOVE_FOLDER_MEMBER_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.REMOVE_FOLDER_MEMBER_ERROR, but was Tag." + this._tag.name());
        }
        return this.removeFolderMemberErrorValue;
    }

    public boolean isRelinquishFolderMembershipError() {
        return this._tag == Tag.RELINQUISH_FOLDER_MEMBERSHIP_ERROR;
    }

    public static JobError relinquishFolderMembershipError(RelinquishFolderMembershipError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new JobError().withTagAndRelinquishFolderMembershipError(Tag.RELINQUISH_FOLDER_MEMBERSHIP_ERROR, value);
    }

    public RelinquishFolderMembershipError getRelinquishFolderMembershipErrorValue() {
        if (this._tag != Tag.RELINQUISH_FOLDER_MEMBERSHIP_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.RELINQUISH_FOLDER_MEMBERSHIP_ERROR, but was Tag." + this._tag.name());
        }
        return this.relinquishFolderMembershipErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.unshareFolderErrorValue, this.removeFolderMemberErrorValue, this.relinquishFolderMembershipErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JobError) {
            JobError other = (JobError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case UNSHARE_FOLDER_ERROR: {
                    return this.unshareFolderErrorValue == other.unshareFolderErrorValue || this.unshareFolderErrorValue.equals(other.unshareFolderErrorValue);
                }
                case REMOVE_FOLDER_MEMBER_ERROR: {
                    return this.removeFolderMemberErrorValue == other.removeFolderMemberErrorValue || this.removeFolderMemberErrorValue.equals(other.removeFolderMemberErrorValue);
                }
                case RELINQUISH_FOLDER_MEMBERSHIP_ERROR: {
                    return this.relinquishFolderMembershipErrorValue == other.relinquishFolderMembershipErrorValue || this.relinquishFolderMembershipErrorValue.equals(other.relinquishFolderMembershipErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<JobError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(JobError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case UNSHARE_FOLDER_ERROR: {
                    g.writeStartObject();
                    this.writeTag("unshare_folder_error", g);
                    g.writeFieldName("unshare_folder_error");
                    UnshareFolderError.Serializer.INSTANCE.serialize(value.unshareFolderErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case REMOVE_FOLDER_MEMBER_ERROR: {
                    g.writeStartObject();
                    this.writeTag("remove_folder_member_error", g);
                    g.writeFieldName("remove_folder_member_error");
                    RemoveFolderMemberError.Serializer.INSTANCE.serialize(value.removeFolderMemberErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case RELINQUISH_FOLDER_MEMBERSHIP_ERROR: {
                    g.writeStartObject();
                    this.writeTag("relinquish_folder_membership_error", g);
                    g.writeFieldName("relinquish_folder_membership_error");
                    RelinquishFolderMembershipError.Serializer.INSTANCE.serialize(value.relinquishFolderMembershipErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public JobError deserialize(JsonParser p) throws IOException, JsonParseException {
            JobError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("unshare_folder_error".equals(tag)) {
                UnshareFolderError fieldValue = null;
                Serializer.expectField("unshare_folder_error", p);
                fieldValue = UnshareFolderError.Serializer.INSTANCE.deserialize(p);
                value = JobError.unshareFolderError(fieldValue);
            } else if ("remove_folder_member_error".equals(tag)) {
                RemoveFolderMemberError fieldValue = null;
                Serializer.expectField("remove_folder_member_error", p);
                fieldValue = RemoveFolderMemberError.Serializer.INSTANCE.deserialize(p);
                value = JobError.removeFolderMemberError(fieldValue);
            } else if ("relinquish_folder_membership_error".equals(tag)) {
                RelinquishFolderMembershipError fieldValue = null;
                Serializer.expectField("relinquish_folder_membership_error", p);
                fieldValue = RelinquishFolderMembershipError.Serializer.INSTANCE.deserialize(p);
                value = JobError.relinquishFolderMembershipError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        UNSHARE_FOLDER_ERROR,
        REMOVE_FOLDER_MEMBER_ERROR,
        RELINQUISH_FOLDER_MEMBERSHIP_ERROR,
        OTHER;

    }
}

