/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.jdocparser;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.kantenkugel.discordbot.jdocparser.Documentation;
import com.kantenkugel.discordbot.jdocparser.JDocParser;
import com.kantenkugel.discordbot.jdocparser.JDocUtil;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsApi;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsBuild;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import okhttp3.Request;
import okhttp3.Response;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class JDoc {
    private static final Map<String, JDocParser.ClassDocumentation> docs = new HashMap<String, JDocParser.ClassDocumentation>();
    private static final Map<String, String> javaJavaDocs = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Documentation> get(String name) {
        String[] methodParts;
        String methodName;
        JDocParser.ClassDocumentation classDoc;
        String[] split = name.toLowerCase().split("[#.]");
        Map<String, JDocParser.ClassDocumentation> map = docs;
        synchronized (map) {
            if (!docs.containsKey(split[0])) {
                return Collections.emptyList();
            }
            classDoc = docs.get(split[0]);
        }
        for (int i2 = 1; i2 < split.length - 1; ++i2) {
            if (!classDoc.subClasses.containsKey(split[i2])) {
                return Collections.emptyList();
            }
            classDoc = classDoc.subClasses.get(split[i2]);
        }
        String searchObj = split[split.length - 1];
        if (split.length == 1 || classDoc.subClasses.containsKey(searchObj)) {
            if (split.length > 1) {
                classDoc = classDoc.subClasses.get(searchObj);
            }
            return Collections.singletonList(classDoc);
        }
        if (classDoc.classValues.containsKey(searchObj)) {
            return Collections.singletonList((Documentation)classDoc.classValues.get(searchObj));
        }
        boolean fuzzy = false;
        String fixedSearchObj = searchObj;
        if (fixedSearchObj.charAt(fixedSearchObj.length() - 1) != ')') {
            fixedSearchObj = fixedSearchObj + "()";
            fuzzy = true;
        }
        if (classDoc.methodDocs.containsKey((methodName = (methodParts = fixedSearchObj.split("[()]"))[0]).toLowerCase())) {
            return JDoc.getMethodDocs(classDoc, methodName, fixedSearchObj, fuzzy);
        }
        if (classDoc.inheritedMethods.containsKey(methodName.toLowerCase())) {
            List<Documentation> inherited = JDoc.get(classDoc.inheritedMethods.get(methodName.toLowerCase()) + '.' + searchObj);
            JDocParser.ClassDocumentation extendingClass = classDoc;
            inherited = inherited.stream().filter(i -> i instanceof JDocParser.MethodDocumentation).map(i -> new InheritedDoc((JDocParser.MethodDocumentation)i, extendingClass)).collect(Collectors.toList());
            return inherited;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Documentation> getJava(String name) {
        String[] methodParts;
        String methodName;
        String urlPath;
        String[] noArgNames = name.toLowerCase().split("\\(")[0].split("[#.]");
        String className = String.join((CharSequence)".", Arrays.copyOf(noArgNames, noArgNames.length - 1));
        Map<String, String> map = javaJavaDocs;
        synchronized (map) {
            urlPath = javaJavaDocs.get(name.toLowerCase());
            if (urlPath == null) {
                urlPath = javaJavaDocs.get(className);
            } else {
                className = name.toLowerCase();
            }
            if (urlPath == null) {
                return Collections.emptyList();
            }
        }
        HashMap<String, JDocParser.ClassDocumentation> resultMap = new HashMap<String, JDocParser.ClassDocumentation>();
        try (Response res = Bot.httpClient.newCall(new Request.Builder().url("https://docs.oracle.com/javase/8/docs/api/" + urlPath).get().build()).execute();){
            if (!res.isSuccessful()) {
                JDocUtil.LOG.warn("OkHttp returned failure for java8 index: " + res.code());
                List<Documentation> list = Collections.emptyList();
                return list;
            }
            JDocParser.parse("https://docs.oracle.com/javase/8/docs/api/", urlPath, res.body().byteStream(), resultMap);
            resultMap.remove("#JDOC_SUBCLASSES_KEY#");
        }
        catch (Exception e) {
            JDocUtil.LOG.error("Error parsing java javadocs for {}", (Object)name, (Object)e);
        }
        if (!resultMap.containsKey(className)) {
            JDocUtil.LOG.warn("Parser didn't return wanted docs");
            return Collections.emptyList();
        }
        JDocParser.ClassDocumentation doc = (JDocParser.ClassDocumentation)resultMap.get(className);
        if (noArgNames.length == 1) return Collections.singletonList(doc);
        if (className.equalsIgnoreCase(name)) {
            return Collections.singletonList(doc);
        }
        String searchObj = name.toLowerCase().substring(className.length() + 1);
        if (doc.classValues.containsKey(searchObj)) {
            return Collections.singletonList((Documentation)doc.classValues.get(searchObj));
        }
        boolean fuzzy = false;
        String fixedSearchObj = searchObj;
        if (fixedSearchObj.charAt(fixedSearchObj.length() - 1) != ')') {
            fixedSearchObj = fixedSearchObj + "()";
            fuzzy = true;
        }
        if (doc.methodDocs.containsKey((methodName = (methodParts = fixedSearchObj.split("[()]"))[0]).toLowerCase())) {
            return JDoc.getMethodDocs(doc, methodName, fixedSearchObj, fuzzy);
        }
        if (!doc.inheritedMethods.containsKey(methodName.toLowerCase())) return Collections.emptyList();
        return JDoc.getJava(doc.inheritedMethods.get(methodName.toLowerCase()) + '.' + searchObj);
    }

    public static Set<Documentation> search(String input, String ... options) throws PatternSyntaxException {
        Set opts = Arrays.stream(options).map(String::toLowerCase).collect(Collectors.toSet());
        boolean isCaseSensitive = opts.contains("cs");
        String key = input.toLowerCase();
        if (opts.contains("f")) {
            return docs.values().stream().flatMap(cls -> cls.methodDocs.entrySet().stream().filter(mds -> ((String)mds.getKey()).contains(key)).map(Map.Entry::getValue).flatMap(Collection::stream)).filter(md -> !isCaseSensitive || md.functionName.contains(input)).collect(Collectors.toSet());
        }
        if (opts.contains("c")) {
            return docs.values().stream().filter(cls -> isCaseSensitive ? cls.className.contains(input) : cls.className.toLowerCase().contains(key)).collect(Collectors.toSet());
        }
        if (opts.contains("var")) {
            return docs.values().stream().flatMap(cls -> cls.classValues.entrySet().stream().filter(val -> ((String)val.getKey()).contains(key)).map(Map.Entry::getValue)).filter(val -> !isCaseSensitive || val.name.contains(input)).collect(Collectors.toSet());
        }
        HashSet<Documentation> results = new HashSet<Documentation>();
        for (JDocParser.ClassDocumentation classDoc : docs.values()) {
            if (isCaseSensitive ? classDoc.className.contains(input) : classDoc.className.toLowerCase().contains(key)) {
                results.add(classDoc);
            }
            for (Set<JDocParser.MethodDocumentation> mdcs : classDoc.methodDocs.values()) {
                for (JDocParser.MethodDocumentation mdc : mdcs) {
                    if (!(isCaseSensitive ? mdc.functionName.contains(input) : mdc.functionName.toLowerCase().contains(key))) continue;
                    results.add(mdc);
                }
            }
            for (JDocParser.ValueDocumentation valueDoc : classDoc.classValues.values()) {
                if (!(isCaseSensitive ? valueDoc.name.contains(input) : valueDoc.name.toLowerCase().contains(key))) continue;
                results.add(valueDoc);
            }
        }
        return results;
    }

    private static List<Documentation> getMethodDocs(JDocParser.ClassDocumentation classDoc, String methodName, String methodSig, boolean isFuzzy) {
        List docs = classDoc.methodDocs.get(methodName.toLowerCase()).stream().sorted(Comparator.comparingInt(m -> m.argTypes.size())).collect(Collectors.toList());
        List filteredDocs = docs.parallelStream().filter(doc -> doc.matches(methodSig, isFuzzy)).collect(Collectors.toList());
        switch (filteredDocs.size()) {
            case 1: {
                return Collections.singletonList((Documentation)filteredDocs.get(0));
            }
            case 0: {
                return Collections.unmodifiableList(docs);
            }
        }
        return Collections.unmodifiableList(filteredDocs);
    }

    public static void init() {
        if (!docs.isEmpty()) {
            return;
        }
        JDocUtil.LOG.info("Initializing Docs...");
        JDoc.download();
        JDoc.fetch();
        JDocUtil.LOG.debug("JDA-Docs initialized, Fetching Java8 class indexes");
        JDoc.fetchJavaClassIndexes();
        JDocUtil.LOG.info("Docs initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reFetch() {
        try {
            JDocUtil.LOG.info("Re-fetching Docs");
            JDoc.download();
            Map<String, JDocParser.ClassDocumentation> map = docs;
            synchronized (map) {
                docs.clear();
            }
            JDoc.fetch();
            JDocUtil.LOG.info("Done");
        }
        catch (Exception e) {
            JDocUtil.LOG.error("Error re-fetching jdocs", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetch() {
        Map<String, JDocParser.ClassDocumentation> newDocs = JDocParser.parse();
        Map<String, JDocParser.ClassDocumentation> map = docs;
        synchronized (map) {
            docs.putAll(newDocs);
        }
    }

    private static void download() {
        block13: {
            try {
                JenkinsBuild lastBuild = JenkinsApi.JDA_JENKINS.getLastSuccessfulBuild();
                if (lastBuild != null) {
                    JDocUtil.LOG.debug("Downloading JDA docs...");
                    try {
                        String artifactUrl = lastBuild.artifacts.get("JDA-javadoc").getLink();
                        try (Response res = Bot.httpClient.newCall(new Request.Builder().url(artifactUrl).get().build()).execute();){
                            if (!res.isSuccessful()) {
                                JDocUtil.LOG.warn("OkHttp returned failure for {}", (Object)artifactUrl);
                                return;
                            }
                            Files.copy(res.body().byteStream(), JDocUtil.LOCAL_DOC_PATH, StandardCopyOption.REPLACE_EXISTING);
                            JDocUtil.LOG.debug("Done downloading JDA docs");
                            break block13;
                        }
                    }
                    catch (Exception e) {
                        JDocUtil.LOG.error("Error downloading jdoc jar", e);
                    }
                    break block13;
                }
                JDocUtil.LOG.warn("There was no Jenkins build?! Skipping download");
            }
            catch (IOException ex) {
                JDocUtil.LOG.warn("Could not contact Jenkins, skipping download");
            }
        }
    }

    private static void fetchJavaClassIndexes() {
        try (Response res = Bot.httpClient.newCall(new Request.Builder().url("https://docs.oracle.com/javase/8/docs/api/allclasses-noframe.html").get().build()).execute();){
            if (!res.isSuccessful()) {
                JDocUtil.LOG.warn("OkHttp returned failure for java8 index: " + res.code());
                return;
            }
            Document docBody = Jsoup.parse(res.body().byteStream(), "UTF-8", "https://docs.oracle.com/javase/8/docs/api/");
            docBody.getElementsByClass("indexContainer").first().child(0).children().forEach(child -> {
                Element link = child.child(0);
                if (link.tagName().equals("a") && link.attr("href").startsWith("java/")) {
                    javaJavaDocs.put(link.text().toLowerCase(), link.attr("href"));
                }
            });
        }
        catch (Exception e) {
            JDocUtil.LOG.error("Failed fetching the j8 class index", e);
        }
    }

    private static class InheritedDoc
    extends JDocParser.MethodDocumentation {
        public InheritedDoc(JDocParser.MethodDocumentation inheritedDoc, JDocParser.ClassDocumentation childClass) {
            super(childClass, inheritedDoc.functionSig, inheritedDoc.hashLink, String.format("**Inherited from %s**\n\n%s", inheritedDoc.parent.className, inheritedDoc.desc), inheritedDoc.fields);
        }
    }
}

