/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.eval;

import com.almightyalpaca.discord.jdabutler.util.MiscUtils;
import com.almightyalpaca.discord.jdabutler.util.StringUtils;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;

public enum Engine {
    GROOVY("Groovy", new String[]{"groovy"}){

        @Override
        public Triple<Object, String, String> eval(Map<String, Object> fields, Collection<String> classImports, Collection<String> packageImports, int timeout, String script) {
            StringBuilder importString = new StringBuilder();
            for (String s : classImports) {
                importString.append("import ").append(s).append(";");
            }
            for (String s : packageImports) {
                importString.append("import ").append(s).append(".*;");
            }
            return this.eval(fields, timeout, importString + script, new GroovyScriptEngineImpl());
        }
    }
    ,
    JAVASCRIPT("JavaScript", new String[]{"js", "javascript"}){
        private final ScriptEngineManager engineManager = new ScriptEngineManager();

        @Override
        public Triple<Object, String, String> eval(Map<String, Object> fields, Collection<String> classImports, Collection<String> packageImports, int timeout, String script) {
            StringBuilder importString = new StringBuilder();
            for (String s : packageImports) {
                importString.append(s).append(", ");
            }
            importString = new StringBuilder(StringUtils.replaceLast(importString.toString(), ", ", ""));
            script = " (function() { with (new JavaImporter(" + importString + ")) {" + script + "} })();";
            return this.eval(fields, timeout, script, this.engineManager.getEngineByName("nashorn"));
        }
    };

    public static final Collection<String> DEFAULT_IMPORTS;
    private static final ScheduledExecutorService service;
    private final List<String> codes;
    private final String name;

    private Engine(String name, String ... codes) {
        this.name = name;
        this.codes = new ArrayList<String>();
        for (String code : codes) {
            this.codes.add(code.toLowerCase());
        }
    }

    public static Engine getEngineByCode(String code) {
        code = code.toLowerCase();
        for (Engine engine : Engine.values()) {
            if (!engine.codes.contains(code)) continue;
            return engine;
        }
        return null;
    }

    public static void shutdown() {
        MoreExecutors.shutdownAndAwaitTermination(service, 10L, TimeUnit.SECONDS);
    }

    public abstract Triple<Object, String, String> eval(Map<String, Object> var1, Collection<String> var2, Collection<String> var3, int var4, String var5);

    public List<String> getCodes() {
        return this.codes;
    }

    public String getName() {
        return this.name;
    }

    protected Triple<Object, String, String> eval(Map<String, Object> fields, int timeout, String script, ScriptEngine engine) {
        for (Map.Entry<String, Object> shortcut : fields.entrySet()) {
            engine.put(shortcut.getKey(), shortcut.getValue());
        }
        StringWriter outString = new StringWriter();
        PrintWriter outWriter = new PrintWriter(outString);
        engine.getContext().setWriter(outWriter);
        StringWriter errorString = new StringWriter();
        PrintWriter errorWriter = new PrintWriter(errorString);
        engine.getContext().setErrorWriter(errorWriter);
        ScheduledFuture<Object> future = service.schedule(() -> engine.eval(script), 0L, TimeUnit.MILLISECONDS);
        Object result = null;
        try {
            result = future.get(timeout, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            errorWriter.println(e.getCause().toString());
        }
        catch (InterruptedException | TimeoutException e) {
            future.cancel(true);
            errorWriter.println(e.toString());
        }
        return new ImmutableTriple<Object, String, String>(result, outString.toString(), errorString.toString());
    }

    static {
        DEFAULT_IMPORTS = Arrays.asList("net.dv8tion.jda.api.entities.impl", "net.dv8tion.jda.api.managers", "net.dv8tion.jda.api.entities", "net.dv8tion.jda.api", "java.lang", "java.io", "java.math", "java.util", "java.util.concurrent", "java.time");
        service = Executors.newScheduledThreadPool(1, MiscUtils.newThreadFactory("eval-thread", false));
    }

    public static class Import {
        private final String name;
        private final Type type;

        public Import(Type type, String name) {
            this.type = type;
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        public final Type getType() {
            return this.type;
        }

        public static enum Type {
            CLASS,
            PACKAGE;

        }
    }
}

