/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.config;

import com.almightyalpaca.discord.jdabutler.config.exception.ConfigSaveException;
import com.almightyalpaca.discord.jdabutler.config.exception.KeyNotFoundException;
import com.almightyalpaca.discord.jdabutler.config.exception.WrongTypeException;
import com.almightyalpaca.discord.jdabutler.util.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class Config {
    private final Config parent;
    protected boolean autoSave;
    protected final JsonObject config;

    protected Config(Config parent, JsonObject config) throws WrongTypeException, KeyNotFoundException {
        this.parent = parent;
        this.config = config;
    }

    public void clear() {
        this.config.entrySet().clear();
    }

    public BigDecimal getBigDecimal(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonObject(key).getAsBigDecimal();
        }
        catch (Exception e) {
            throw new WrongTypeException(e);
        }
    }

    public final BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getBigDecimal(key);
    }

    public BigInteger getBigInteger(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonObject(key).getAsBigInteger();
        }
        catch (Exception e) {
            throw new WrongTypeException(e);
        }
    }

    public final BigInteger getBigInteger(String key, BigInteger defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getBigInteger(key);
    }

    public boolean getBoolean(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonPrimitive(key).getAsBoolean();
        }
        catch (Exception e) {
            throw new WrongTypeException(e);
        }
    }

    public final boolean getBoolean(String key, boolean defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getBoolean(key);
    }

    public byte getByte(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonPrimitive(key).getAsByte();
        }
        catch (Exception e) {
            throw new WrongTypeException(e);
        }
    }

    public final byte getByte(String key, byte defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getByte(key);
    }

    public char getCharacter(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonPrimitive(key).getAsCharacter();
        }
        catch (Exception e) {
            throw new WrongTypeException(e);
        }
    }

    public final char getCharacter(String key, char defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, Character.valueOf(defaultValue));
        }
        return this.getCharacter(key);
    }

    public Config getConfig(String key) throws WrongTypeException, KeyNotFoundException {
        return this.getConfig(key, new Config(this, new JsonObject()));
    }

    public final Config getConfig(String key, Config defaultValue) {
        return this.getConfig(key, defaultValue.config);
    }

    public final Config getConfig(String key, JsonObject defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return new Config(this, this.getJsonObject(key));
    }

    public File getConfigFile() {
        return this.parent.getConfigFile();
    }

    public double getDouble(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonPrimitive(key).getAsDouble();
        }
        catch (NumberFormatException e) {
            throw new WrongTypeException(e);
        }
        catch (NullPointerException e) {
            throw new KeyNotFoundException(e);
        }
    }

    public final double getDouble(String key, double defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getDouble(key);
    }

    public Map<String, Object> getEntries() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, JsonElement> entry : this.config.getAsJsonObject().entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public float getFloat(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonPrimitive(key).getAsFloat();
        }
        catch (NumberFormatException e) {
            throw new WrongTypeException(e);
        }
        catch (NullPointerException e) {
            throw new KeyNotFoundException(e);
        }
    }

    public final float getFloat(String key, float defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, Float.valueOf(defaultValue));
        }
        return this.getFloat(key);
    }

    public int getInt(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonPrimitive(key).getAsInt();
        }
        catch (NumberFormatException e) {
            throw new WrongTypeException(e);
        }
        catch (NullPointerException e) {
            throw new KeyNotFoundException(e);
        }
    }

    public final int getInt(String key, int defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getInt(key);
    }

    public JsonArray getJsonArray(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonElement(key).getAsJsonArray();
        }
        catch (IllegalStateException e) {
            throw new WrongTypeException(e);
        }
        catch (NullPointerException e) {
            throw new KeyNotFoundException(e);
        }
    }

    public final JsonArray getJsonArray(String key, JsonArray defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getJsonArray(key);
    }

    public JsonElement getJsonElement(String key) throws KeyNotFoundException, WrongTypeException {
        String[] path = key.split("\\.");
        JsonElement value = this.config;
        try {
            for (String element : path) {
                if (element.trim().isEmpty()) continue;
                if (element.endsWith("]") && element.contains("[")) {
                    int index;
                    int i = element.lastIndexOf("[");
                    try {
                        index = Integer.parseInt(element.substring(i).replace("[", "").replace("]", ""));
                    }
                    catch (Exception e) {
                        index = 0;
                    }
                    element = element.substring(0, i);
                    value = value.getAsJsonObject().get(element);
                    value = value.getAsJsonArray().get(index);
                    continue;
                }
                value = value.getAsJsonObject().get(element);
            }
            if (value == null) {
                throw new NullPointerException();
            }
            return value;
        }
        catch (IllegalStateException e) {
            throw new WrongTypeException(e);
        }
        catch (NullPointerException e) {
            throw new KeyNotFoundException(e);
        }
    }

    public final JsonElement getJsonElement(String key, JsonElement defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getJsonElement(key);
    }

    public JsonObject getJsonObject(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonElement(key).getAsJsonObject();
        }
        catch (IllegalStateException e) {
            throw new WrongTypeException(e);
        }
        catch (NullPointerException e) {
            throw new KeyNotFoundException(e);
        }
    }

    public final JsonObject getJsonObject(String key, JsonObject defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getJsonObject(key);
    }

    public JsonPrimitive getJsonPrimitive(String key) throws KeyNotFoundException, WrongTypeException {
        try {
            return this.getJsonElement(key).getAsJsonPrimitive();
        }
        catch (IllegalStateException e) {
            throw new WrongTypeException(e);
        }
        catch (NullPointerException e) {
            throw new KeyNotFoundException(e);
        }
    }

    public final JsonPrimitive getJsonPrimitive(String key, JsonPrimitive defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getJsonPrimitive(key);
    }

    public long getLong(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonPrimitive(key).getAsLong();
        }
        catch (NumberFormatException e) {
            throw new WrongTypeException(e);
        }
        catch (NullPointerException e) {
            throw new KeyNotFoundException(e);
        }
    }

    public final long getLong(String key, long defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getLong(key);
    }

    public Number getNumber(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonPrimitive(key).getAsNumber();
        }
        catch (NumberFormatException e) {
            throw new WrongTypeException(e);
        }
        catch (NullPointerException e) {
            throw new KeyNotFoundException(e);
        }
    }

    public final Number getNumber(String key, Number defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getNumber(key);
    }

    public short getShort(String key) throws WrongTypeException, KeyNotFoundException {
        try {
            return this.getJsonPrimitive(key).getAsShort();
        }
        catch (Exception e) {
            throw new WrongTypeException(e);
        }
    }

    public final short getShort(String key, short defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getShort(key);
    }

    public String getString(String key) throws WrongTypeException, KeyNotFoundException {
        return this.getJsonPrimitive(key).getAsString();
    }

    public final String getString(String key, String defaultValue) {
        if (!this.hasKey(key)) {
            this.put(key, defaultValue);
        }
        return this.getString(key);
    }

    public boolean hasKey(String key) {
        try {
            this.getJsonElement(key);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.config.entrySet().isEmpty();
    }

    public void put(String key, boolean value) {
        this.put(key, new JsonPrimitive(value));
    }

    public void put(String key, Character value) {
        this.put(key, new JsonPrimitive(value));
    }

    public Config put(String key, Config value) {
        this.put(key, value.config);
        return this.getConfig(key);
    }

    public void put(String key, JsonElement value) throws WrongTypeException {
        String finalKey = key.substring(key.lastIndexOf(".") + 1);
        if ((key = StringUtils.replaceLast(key, finalKey, "")).endsWith(".")) {
            key = StringUtils.replaceLast(key, ".", "");
        }
        String[] path = key.split("\\.");
        JsonObject current = this.config;
        try {
            for (String element : path) {
                if (element.trim().isEmpty()) continue;
                if (element.endsWith("]") && element.contains("[")) {
                    int index;
                    int i = element.lastIndexOf("[");
                    try {
                        index = Integer.parseInt(element.substring(i).replace("[", "").replace("]", ""));
                    }
                    catch (Exception e) {
                        index = -1;
                    }
                    element = element.substring(0, i);
                    if (!current.has(element)) {
                        current.add(element, new JsonArray());
                    }
                    JsonArray array = current.get(element).getAsJsonArray();
                    if (index == -1) {
                        JsonObject object = new JsonObject();
                        array.add(object);
                        current = object;
                        continue;
                    }
                    if (index == array.size()) {
                        array.add(new JsonObject());
                    }
                    current = array.get(index).getAsJsonObject();
                    continue;
                }
                if (!current.has(element)) {
                    current.add(element, new JsonObject());
                }
                current = current.get(element).getAsJsonObject();
            }
        }
        catch (IllegalStateException e) {
            throw new WrongTypeException(e);
        }
        current.add(finalKey, value);
    }

    public void put(String key, Number value) {
        this.put(key, new JsonPrimitive(value));
    }

    public void put(String key, String value) {
        this.put(key, new JsonPrimitive(value));
    }

    public void remove(String key) {
        this.config.remove(key);
    }

    public void rename(String from, String to) throws KeyNotFoundException, WrongTypeException {
        this.put(to, this.getJsonElement(from));
        this.remove(from);
    }

    public void save() throws ConfigSaveException {
        this.parent.save();
    }

    public Config setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
        return this;
    }

    public String toString() {
        return this.config.toString();
    }
}

