/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.PaperDocPermissionLevel;
import com.dropbox.core.v2.sharing.MemberSelector;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class AddMember {
    protected final PaperDocPermissionLevel permissionLevel;
    protected final MemberSelector member;

    public AddMember(MemberSelector member, PaperDocPermissionLevel permissionLevel) {
        if (permissionLevel == null) {
            throw new IllegalArgumentException("Required value for 'permissionLevel' is null");
        }
        this.permissionLevel = permissionLevel;
        if (member == null) {
            throw new IllegalArgumentException("Required value for 'member' is null");
        }
        this.member = member;
    }

    public AddMember(MemberSelector member) {
        this(member, PaperDocPermissionLevel.EDIT);
    }

    public MemberSelector getMember() {
        return this.member;
    }

    public PaperDocPermissionLevel getPermissionLevel() {
        return this.permissionLevel;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.permissionLevel, this.member});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            AddMember other = (AddMember)obj;
            return !(this.member != other.member && !this.member.equals(other.member) || this.permissionLevel != other.permissionLevel && !this.permissionLevel.equals((Object)other.permissionLevel));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<AddMember> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AddMember value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("member");
            MemberSelector.Serializer.INSTANCE.serialize(value.member, g);
            g.writeFieldName("permission_level");
            PaperDocPermissionLevel.Serializer.INSTANCE.serialize(value.permissionLevel, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public AddMember deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            PaperDocPermissionLevel f_permissionLevel;
            MemberSelector f_member;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_member = null;
                f_permissionLevel = PaperDocPermissionLevel.EDIT;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("member".equals(field)) {
                        f_member = MemberSelector.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("permission_level".equals(field)) {
                        f_permissionLevel = PaperDocPermissionLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_member == null) {
                    throw new JsonParseException(p, "Required field \"member\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            AddMember value = new AddMember(f_member, f_permissionLevel);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

