/*
 * Decompiled with CFR 0.152.
 */
package club.minnced.discord.webhook.send;

import club.minnced.discord.webhook.send.MessageAttachment;
import club.minnced.discord.webhook.send.WebhookEmbed;
import club.minnced.discord.webhook.send.WebhookMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebhookMessageBuilder {
    protected final StringBuilder content = new StringBuilder();
    protected final List<WebhookEmbed> embeds = new LinkedList<WebhookEmbed>();
    protected final MessageAttachment[] files = new MessageAttachment[10];
    protected String username;
    protected String avatarUrl;
    protected String nonce;
    protected boolean isTTS;
    private int fileIndex = 0;

    public boolean isEmpty() {
        return this.content.length() == 0 && this.embeds.isEmpty() && this.getFileAmount() == 0;
    }

    public int getFileAmount() {
        return this.fileIndex;
    }

    @NotNull
    public WebhookMessageBuilder reset() {
        this.content.setLength(0);
        this.resetEmbeds();
        this.resetFiles();
        this.username = null;
        this.avatarUrl = null;
        this.isTTS = false;
        return this;
    }

    @NotNull
    public WebhookMessageBuilder resetFiles() {
        for (int i = 0; i < 10; ++i) {
            this.files[i] = null;
        }
        this.fileIndex = 0;
        return this;
    }

    @NotNull
    public WebhookMessageBuilder resetEmbeds() {
        this.embeds.clear();
        return this;
    }

    @NotNull
    public WebhookMessageBuilder addEmbeds(WebhookEmbed ... embeds) {
        Objects.requireNonNull(embeds, "Embeds");
        if (this.embeds.size() + embeds.length > 10) {
            throw new IllegalStateException("Cannot add more than 10 embeds to a message");
        }
        for (WebhookEmbed embed : embeds) {
            Objects.requireNonNull(embed, "Embed");
            this.embeds.add(embed);
        }
        return this;
    }

    @NotNull
    public WebhookMessageBuilder addEmbeds(@NotNull Collection<? extends WebhookEmbed> embeds) {
        Objects.requireNonNull(embeds, "Embeds");
        if (this.embeds.size() + embeds.size() > 10) {
            throw new IllegalStateException("Cannot add more than 10 embeds to a message");
        }
        for (WebhookEmbed webhookEmbed : embeds) {
            Objects.requireNonNull(webhookEmbed, "Embed");
            this.embeds.add(webhookEmbed);
        }
        return this;
    }

    @NotNull
    public WebhookMessageBuilder setContent(@Nullable String content) {
        if (content != null && content.length() > 2000) {
            throw new IllegalArgumentException("Content may not exceed 2000 characters!");
        }
        if (content != null) {
            this.content.replace(0, content.length(), content);
        } else {
            this.content.setLength(0);
        }
        return this;
    }

    @NotNull
    public WebhookMessageBuilder setNonce(@Nullable String nonce) {
        this.nonce = nonce;
        return this;
    }

    @NotNull
    public WebhookMessageBuilder append(@NotNull String content) {
        Objects.requireNonNull(content, "Content");
        if (this.content.length() + content.length() > 2000) {
            throw new IllegalArgumentException("Content may not exceed 2000 characters!");
        }
        this.content.append(content);
        return this;
    }

    @NotNull
    public WebhookMessageBuilder setUsername(@Nullable String username) {
        this.username = username == null || username.trim().isEmpty() ? null : username.trim();
        return this;
    }

    @NotNull
    public WebhookMessageBuilder setAvatarUrl(@Nullable String avatarUrl) {
        this.avatarUrl = avatarUrl == null || avatarUrl.trim().isEmpty() ? null : avatarUrl.trim();
        return this;
    }

    @NotNull
    public WebhookMessageBuilder setTTS(boolean tts) {
        this.isTTS = tts;
        return this;
    }

    @NotNull
    public WebhookMessageBuilder addFile(@NotNull File file) {
        Objects.requireNonNull(file, "File");
        return this.addFile(file.getName(), file);
    }

    @NotNull
    public WebhookMessageBuilder addFile(@NotNull String name, @NotNull File file) {
        Objects.requireNonNull(file, "File");
        Objects.requireNonNull(name, "Name");
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("File must exist and be readable");
        }
        if (this.fileIndex >= 10) {
            throw new IllegalStateException("Cannot add more than 10 attachments to a message");
        }
        try {
            MessageAttachment attachment = new MessageAttachment(name, file);
            this.files[this.fileIndex++] = attachment;
            return this;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NotNull
    public WebhookMessageBuilder addFile(@NotNull String name, @NotNull byte[] data) {
        Objects.requireNonNull(data, "Data");
        Objects.requireNonNull(name, "Name");
        if (this.fileIndex >= 10) {
            throw new IllegalStateException("Cannot add more than 10 attachments to a message");
        }
        MessageAttachment attachment = new MessageAttachment(name, data);
        this.files[this.fileIndex++] = attachment;
        return this;
    }

    @NotNull
    public WebhookMessageBuilder addFile(@NotNull String name, @NotNull InputStream data) {
        Objects.requireNonNull(data, "InputStream");
        Objects.requireNonNull(name, "Name");
        if (this.fileIndex >= 10) {
            throw new IllegalStateException("Cannot add more than 10 attachments to a message");
        }
        try {
            MessageAttachment attachment = new MessageAttachment(name, data);
            this.files[this.fileIndex++] = attachment;
            return this;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NotNull
    public WebhookMessage build() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot build an empty message!");
        }
        return new WebhookMessage(this.username, this.avatarUrl, this.content.toString(), this.nonce, this.embeds, this.isTTS, this.fileIndex == 0 ? null : Arrays.copyOf(this.files, this.fileIndex));
    }
}

