/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck.items;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.util.EmbedUtil;
import com.almightyalpaca.discord.jdabutler.util.FormattingUtil;
import com.almightyalpaca.discord.jdabutler.util.MiscUtils;
import com.almightyalpaca.discord.jdabutler.util.gradle.GradleProjectDropboxUtil;
import com.kantenkugel.discordbot.jdocparser.JDoc;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsApi;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsBuild;
import com.kantenkugel.discordbot.versioncheck.JenkinsVersionSupplier;
import com.kantenkugel.discordbot.versioncheck.RepoType;
import com.kantenkugel.discordbot.versioncheck.UpdateHandler;
import com.kantenkugel.discordbot.versioncheck.changelog.ChangelogProvider;
import com.kantenkugel.discordbot.versioncheck.changelog.JenkinsChangelogProvider;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.MessageBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;

public class JDAItem
extends VersionedItem
implements UpdateHandler {
    private final ChangelogProvider changelogProvider;
    private final Supplier<String> versionSupplier;
    private final long roleId;
    private final long channelId;
    private final String job;
    private final JenkinsApi jenkins;

    public JDAItem() {
        this(JenkinsApi.JDA_JENKINS, 241948671325765632L, 125227483518861312L, "JDA");
    }

    public JDAItem(JenkinsApi api, long roleId, long channelId, String job) {
        this.roleId = roleId;
        this.channelId = channelId;
        this.job = job;
        this.changelogProvider = new JenkinsChangelogProvider(api, "https://github.com/DV8FromTheWorld/JDA/");
        this.versionSupplier = new JenkinsVersionSupplier(api);
        this.jenkins = api;
    }

    @Override
    public Supplier<String> getCustomVersionSupplier() {
        return this.versionSupplier;
    }

    @Override
    public String getName() {
        return this.job;
    }

    @Override
    public String getDescription() {
        return "Updates for every " + this.getName() + " development build";
    }

    @Override
    public RepoType getRepoType() {
        return RepoType.M2_DV8TION;
    }

    @Override
    public String getGroupId() {
        return "net.dv8tion";
    }

    @Override
    public String getArtifactId() {
        return "JDA";
    }

    @Override
    public String getUrl() {
        return this.jenkins.getLastSuccessfulBuildUrl();
    }

    @Override
    public long getAnnouncementRoleId() {
        return this.roleId;
    }

    @Override
    public long getAnnouncementChannelId() {
        return this.channelId;
    }

    @Override
    public UpdateHandler getUpdateHandler() {
        return this;
    }

    @Override
    public ChangelogProvider getChangelogProvider() {
        return this.changelogProvider;
    }

    @Override
    public void onUpdate(VersionedItem item, String previousVersion, boolean shouldAnnounce) {
        boolean isActualJDA = this.getName().equalsIgnoreCase("jda");
        String version = item.getVersion();
        int buildNumber = Integer.parseInt(version.substring(version.indexOf("_") + 1));
        if (!isActualJDA || buildNumber != Bot.config.getInt("jda.version.build", -1)) {
            JenkinsBuild jenkinsBuild;
            Bot.LOG.debug("Update found!");
            if (isActualJDA) {
                Bot.config.put("jda.version.build", buildNumber);
                Bot.config.put("jda.version.name", version);
                Bot.config.save();
            }
            try {
                jenkinsBuild = this.jenkins.fetchLastSuccessfulBuild();
            }
            catch (IOException ex) {
                Bot.LOG.warn("Could not fetch latest Jenkins build in JDAItem#onUpdate()", ex);
                return;
            }
            if (jenkinsBuild == null) {
                Bot.LOG.warn("Could not fetch Jenkins-build for new version (triggered by maven update)");
                return;
            }
            if (isActualJDA) {
                Bot.EXECUTOR.submit(() -> {
                    JDoc.reFetch();
                    GradleProjectDropboxUtil.uploadProject();
                });
            }
            if (!shouldAnnounce) {
                return;
            }
            EmbedBuilder eb = new EmbedBuilder();
            MessageBuilder mb = new MessageBuilder();
            FormattingUtil.setFooter(eb, jenkinsBuild.culprits, jenkinsBuild.buildTime);
            Role announcementRole = this.getAnnouncementRole();
            mb.append(announcementRole.getAsMention());
            eb.setAuthor("JDA version " + version + " has been released\n", this.jenkins.jenkinsBase + buildNumber, EmbedUtil.getJDAIconUrl());
            EmbedUtil.setColor(eb);
            if (jenkinsBuild.changes.size() > 0) {
                eb.setTitle("\u200e", null);
                ChangelogProvider.Changelog changelog = this.getChangelogProvider().getChangelog(Integer.toString(jenkinsBuild.buildNum));
                List<String> changeset = changelog.getChangeset();
                int fields = changeset.size() > 25 ? 24 : Math.min(changeset.size(), 25);
                for (int j = 0; j < fields; ++j) {
                    String field = changeset.get(j);
                    eb.addField(j == 0 ? "Commits:" : "", field, false);
                }
                if (changeset.size() > 25) {
                    eb.addField("", "max embed length reached", false);
                }
            }
            MessageEmbed embed = eb.build();
            mb.setEmbed(embed);
            TextChannel channel = this.getAnnouncementChannel();
            MiscUtils.announce(channel, announcementRole, mb.build(), true);
        }
    }
}

