/*
 * Decompiled with CFR 0.152.
 */
package club.minnced.discord.webhook.send;

import club.minnced.discord.webhook.send.WebhookEmbed;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebhookEmbedBuilder {
    private final List<WebhookEmbed.EmbedField> fields = new ArrayList<WebhookEmbed.EmbedField>(10);
    private OffsetDateTime timestamp;
    private Integer color;
    private String description;
    private String thumbnailUrl;
    private String imageUrl;
    private WebhookEmbed.EmbedFooter footer;
    private WebhookEmbed.EmbedTitle title;
    private WebhookEmbed.EmbedAuthor author;

    public WebhookEmbedBuilder() {
    }

    public WebhookEmbedBuilder(@Nullable WebhookEmbed embed) {
        this();
        if (embed != null) {
            this.timestamp = embed.getTimestamp();
            this.color = embed.getColor();
            this.description = embed.getDescription();
            this.thumbnailUrl = embed.getThumbnailUrl();
            this.imageUrl = embed.getImageUrl();
            this.footer = embed.getFooter();
            this.title = embed.getTitle();
            this.author = embed.getAuthor();
            this.fields.addAll(embed.getFields());
        }
    }

    public void reset() {
        this.fields.clear();
        this.timestamp = null;
        this.color = null;
        this.description = null;
        this.thumbnailUrl = null;
        this.imageUrl = null;
        this.footer = null;
        this.title = null;
        this.author = null;
    }

    @NotNull
    public WebhookEmbedBuilder setTimestamp(@Nullable TemporalAccessor timestamp) {
        this.timestamp = timestamp instanceof Instant ? OffsetDateTime.ofInstant((Instant)timestamp, ZoneId.of("UTC")) : (timestamp == null ? null : OffsetDateTime.from(timestamp));
        return this;
    }

    @NotNull
    public WebhookEmbedBuilder setColor(@Nullable Integer color) {
        this.color = color;
        return this;
    }

    @NotNull
    public WebhookEmbedBuilder setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @NotNull
    public WebhookEmbedBuilder setThumbnailUrl(@Nullable String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
        return this;
    }

    @NotNull
    public WebhookEmbedBuilder setImageUrl(@Nullable String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @NotNull
    public WebhookEmbedBuilder setFooter(@Nullable WebhookEmbed.EmbedFooter footer) {
        this.footer = footer;
        return this;
    }

    @NotNull
    public WebhookEmbedBuilder setTitle(@Nullable WebhookEmbed.EmbedTitle title) {
        this.title = title;
        return this;
    }

    @NotNull
    public WebhookEmbedBuilder setAuthor(@Nullable WebhookEmbed.EmbedAuthor author) {
        this.author = author;
        return this;
    }

    @NotNull
    public WebhookEmbedBuilder addField(@NotNull WebhookEmbed.EmbedField field) {
        if (this.fields.size() == 25) {
            throw new IllegalStateException("Cannot add more than 25 fields");
        }
        this.fields.add(Objects.requireNonNull(field));
        return this;
    }

    public boolean isEmpty() {
        return this.isEmpty(this.description) && this.isEmpty(this.imageUrl) && this.isFieldsEmpty() && this.isAuthorEmpty() && this.isTitleEmpty() && this.isFooterEmpty();
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private boolean isTitleEmpty() {
        return this.title == null || this.isEmpty(this.title.getText());
    }

    private boolean isFooterEmpty() {
        return this.footer == null || this.isEmpty(this.footer.getText());
    }

    private boolean isAuthorEmpty() {
        return this.author == null || this.isEmpty(this.author.getName());
    }

    private boolean isFieldsEmpty() {
        if (this.fields.isEmpty()) {
            return true;
        }
        return this.fields.stream().allMatch(f -> this.isEmpty(f.getName()) && this.isEmpty(f.getValue()));
    }

    @NotNull
    public WebhookEmbed build() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot build an empty embed");
        }
        return new WebhookEmbed(this.timestamp, this.color, this.description, this.thumbnailUrl, this.imageUrl, this.footer, this.title, this.author, new ArrayList<WebhookEmbed.EmbedField>(this.fields));
    }
}

