/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.jenkinsutil;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.util.FixedSizeCache;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsBuild;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsApi {
    public static final String JDA_JENKINS_BASE = "https://ci.dv8tion.net";
    public static final JenkinsApi JDA_JENKINS = JenkinsApi.forConfig("https://ci.dv8tion.net", "JDA");
    static final Logger LOG = LoggerFactory.getLogger(JenkinsApi.class);
    private static final String API_SUFFIX = "api/json?";
    private static final String BUILD_OPTIONS = "tree=artifacts[*],id,building,result,timestamp,changeSet[items[commitId,date,comment,author[fullName,id,description],paths[*]]],culprits[fullName,id,description]";
    private static final String LATEST_SUCC_SUFFIX = "lastSuccessfulBuild/";
    private static final String CHANGE_SUFFIX = "changes";
    public final String jenkinsBase;
    private final FixedSizeCache<Integer, JenkinsBuild> resultCache = new FixedSizeCache(20);
    private JenkinsBuild lastSuccBuild = null;

    public static JenkinsApi forConfig(String baseUrl, String jobName) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + '/';
        }
        return JenkinsApi.forConfig(baseUrl + "job/" + jobName);
    }

    public static JenkinsApi forConfig(String fullJobPath) {
        if (!fullJobPath.endsWith("/")) {
            fullJobPath = fullJobPath + '/';
        }
        return new JenkinsApi(fullJobPath);
    }

    public JenkinsBuild getBuild(int buildNumber) throws IOException {
        return this.resultCache.contains(buildNumber) ? this.resultCache.get(buildNumber) : this.getBuild(buildNumber + "/");
    }

    public JenkinsBuild fetchLastSuccessfulBuild() throws IOException {
        this.lastSuccBuild = this.getBuild(LATEST_SUCC_SUFFIX);
        return this.lastSuccBuild;
    }

    public JenkinsBuild getLastSuccessfulBuild() throws IOException {
        if (this.lastSuccBuild == null) {
            return this.fetchLastSuccessfulBuild();
        }
        return this.lastSuccBuild;
    }

    public String getChangesetUrl() {
        return this.jenkinsBase + CHANGE_SUFFIX;
    }

    public String getLastSuccessfulBuildUrl() {
        return this.jenkinsBase + LATEST_SUCC_SUFFIX;
    }

    private JenkinsBuild getBuild(String identifier) throws IOException {
        Request req = new Request.Builder().url(this.jenkinsBase + identifier + API_SUFFIX + BUILD_OPTIONS).get().build();
        try (Response res = Bot.httpClient.newCall(req).execute();){
            if (!res.isSuccessful()) {
                JenkinsBuild jenkinsBuild = null;
                return jenkinsBuild;
            }
            JenkinsBuild build = JenkinsBuild.fromJson(new JSONObject(new JSONTokener(res.body().charStream())), this);
            if (build.status != JenkinsBuild.Status.BUILDING) {
                this.resultCache.add(build.buildNum, build);
            }
            JenkinsBuild jenkinsBuild = build;
            return jenkinsBuild;
        }
    }

    private JenkinsApi(String jenkinsurl) {
        this.jenkinsBase = jenkinsurl;
    }
}

