/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.config;

import com.almightyalpaca.discord.jdabutler.config.Config;
import com.almightyalpaca.discord.jdabutler.config.exception.ConfigSaveException;
import com.almightyalpaca.discord.jdabutler.config.exception.KeyNotFoundException;
import com.almightyalpaca.discord.jdabutler.config.exception.WrongTypeException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.text.translate.UnicodeUnescaper;

public class RootConfig
extends Config {
    private final File configFile;

    RootConfig(File file) throws WrongTypeException, KeyNotFoundException, JsonIOException, JsonSyntaxException, FileNotFoundException {
        super(null, new JsonParser().parse(new FileReader(file)).getAsJsonObject());
        this.configFile = file;
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public void save() throws ConfigSaveException {
        Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().serializeSpecialFloatingPointValues().create();
        String json = gson.toJson(this.config);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), "UTF-8"));
            new UnicodeUnescaper().translate(json, writer);
            writer.close();
        }
        catch (IOException e) {
            throw new ConfigSaveException(e);
        }
    }
}

