/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.util.MiscUtils;
import com.kantenkugel.discordbot.versioncheck.VersionCheckerRegistry;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.io.UncheckedIOException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.dv8tion.jda.internal.utils.tuple.Pair;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersionChecker {
    public static final Logger LOG = LoggerFactory.getLogger(VersionChecker.class);
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(2, MiscUtils.newThreadFactory("versionchecker-thread", LOG));

    public static Set<Pair<VersionedItem, String>> checkVersions() {
        HashSet<Pair<VersionedItem, String>> changedItems = new HashSet<Pair<VersionedItem, String>>();
        VersionCheckerRegistry.getVersionedItems().forEach(item -> {
            String version = VersionChecker.getVersion(item);
            if (!(version == null || item.getVersion() != null && item.getVersion().equals(version))) {
                changedItems.add(Pair.of(item, item.getVersion()));
                item.setVersion(version);
            }
        });
        return changedItems;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getVersion(VersionedItem item) {
        try {
            Supplier<String> versionSupplier = item.getCustomVersionSupplier();
            if (versionSupplier != null) {
                return versionSupplier.get();
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            try (Response res = Bot.httpClient.newCall(new Request.Builder().url(item.getRepoUrl()).get().build()).execute();){
                if (!res.isSuccessful()) {
                    LOG.warn("Could not fetch Maven metadata from " + item.getRepoUrl() + " - OkHttp returned with failure");
                    String string = null;
                    return string;
                }
                Document doc = dBuilder.parse(res.body().byteStream());
                Element root = doc.getDocumentElement();
                root.normalize();
                Element versioningElem = (Element)root.getElementsByTagName("versioning").item(0);
                if (versioningElem == null) {
                    LOG.warn("Could not find versioning node for item {}", (Object)item.getName());
                    String string = null;
                    return string;
                }
                Element versionElem = (Element)versioningElem.getElementsByTagName("release").item(0);
                if (versionElem == null) {
                    LOG.warn("Could not find release node for item {}", (Object)item.getName());
                    String string = null;
                    return string;
                }
                String string = versionElem.getTextContent();
                return string;
            }
        }
        catch (UncheckedIOException | SocketTimeoutException ex) {
            if (!(ex instanceof SocketTimeoutException) && ex.getCause().getClass() != SocketTimeoutException.class) {
                LOG.error("Could not fetch version info for item {}", (Object)item.getName(), (Object)ex);
                return null;
            }
            LOG.warn("Version-fetch for item {} timed out", (Object)item.getName());
            return null;
        }
        catch (Exception e) {
            LOG.error("Could not fetch version info for item {}", (Object)item.getName(), (Object)e);
        }
        return null;
    }

    static void initUpdateLoop() {
        int delayMinutes = 1 + VersionCheckerRegistry.getVersionedItems().size() / 5;
        EXECUTOR.scheduleWithFixedDelay(() -> {
            Set changedItems;
            LOG.debug("Checking for updates...");
            Future<Set> check = EXECUTOR.submit(VersionChecker::checkVersions);
            try {
                changedItems = check.get(delayMinutes, TimeUnit.MINUTES);
            }
            catch (TimeoutException ex) {
                check.cancel(true);
                LOG.warn("Version-checking timed out");
                return;
            }
            catch (Exception ex) {
                LOG.error("There was an error fetching newest versions", ex);
                return;
            }
            boolean shouldAnnounce = !Bot.config.getBoolean("testing", true) && !Bot.isStealth;
            for (Pair changedItemPair : changedItems) {
                VersionedItem changedItem = (VersionedItem)changedItemPair.getLeft();
                if (changedItem.getUpdateHandler() == null) continue;
                Future<?> updateTask = EXECUTOR.submit(() -> {
                    try {
                        changedItem.getUpdateHandler().onUpdate(changedItem, (String)changedItemPair.getRight(), shouldAnnounce);
                    }
                    catch (Exception ex) {
                        LOG.warn("UpdateHandler for {} failed", (Object)changedItem.getName(), (Object)ex);
                    }
                });
                try {
                    updateTask.get(30L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    updateTask.cancel(true);
                    LOG.warn("UpdateHandler for {} timed out!", (Object)changedItem.getName());
                }
                catch (Exception e) {
                    LOG.error("There was an error executing the UpdateHandler for {}", (Object)changedItem.getName());
                }
            }
        }, delayMinutes, delayMinutes, TimeUnit.MINUTES);
    }
}

