/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public enum RepoType {
    JCENTER("https://jcenter.bintray.com/", Pair.of("jcenter()", null), "bintray"),
    MAVENCENTRAL("https://repo.maven.apache.org/maven2/", null, "central", "maven");

    private final String repoBase;
    private final Pair<String, String> gradleImport;
    private final List<String> aliases;

    private RepoType(String repoBase, Pair<String, String> gradleImport, String ... aliases) {
        this.repoBase = repoBase;
        this.gradleImport = gradleImport;
        this.aliases = Arrays.asList(aliases);
    }

    public String getRepoBase() {
        return this.repoBase;
    }

    public Pair<String, String> getGradleImport() {
        return this.gradleImport;
    }

    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    public static RepoType fromString(String value) {
        value = value.toLowerCase();
        for (RepoType repoType : RepoType.values()) {
            if (!repoType.toString().equals(value) && !repoType.aliases.contains(value)) continue;
            return repoType;
        }
        return null;
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

