/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.teamlog.ApiSessionLogInfo;
import com.dropbox.core.v2.teamlog.SessionLogInfo;
import com.dropbox.core.v2.teamlog.WebSessionLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class AccessMethodLogInfo {
    public static final AccessMethodLogInfo OTHER = new AccessMethodLogInfo().withTag(Tag.OTHER);
    private Tag _tag;
    private SessionLogInfo endUserValue;
    private WebSessionLogInfo signInAsValue;
    private WebSessionLogInfo contentManagerValue;
    private WebSessionLogInfo adminConsoleValue;
    private ApiSessionLogInfo apiValue;

    private AccessMethodLogInfo() {
    }

    private AccessMethodLogInfo withTag(Tag _tag) {
        AccessMethodLogInfo result = new AccessMethodLogInfo();
        result._tag = _tag;
        return result;
    }

    private AccessMethodLogInfo withTagAndEndUser(Tag _tag, SessionLogInfo endUserValue) {
        AccessMethodLogInfo result = new AccessMethodLogInfo();
        result._tag = _tag;
        result.endUserValue = endUserValue;
        return result;
    }

    private AccessMethodLogInfo withTagAndSignInAs(Tag _tag, WebSessionLogInfo signInAsValue) {
        AccessMethodLogInfo result = new AccessMethodLogInfo();
        result._tag = _tag;
        result.signInAsValue = signInAsValue;
        return result;
    }

    private AccessMethodLogInfo withTagAndContentManager(Tag _tag, WebSessionLogInfo contentManagerValue) {
        AccessMethodLogInfo result = new AccessMethodLogInfo();
        result._tag = _tag;
        result.contentManagerValue = contentManagerValue;
        return result;
    }

    private AccessMethodLogInfo withTagAndAdminConsole(Tag _tag, WebSessionLogInfo adminConsoleValue) {
        AccessMethodLogInfo result = new AccessMethodLogInfo();
        result._tag = _tag;
        result.adminConsoleValue = adminConsoleValue;
        return result;
    }

    private AccessMethodLogInfo withTagAndApi(Tag _tag, ApiSessionLogInfo apiValue) {
        AccessMethodLogInfo result = new AccessMethodLogInfo();
        result._tag = _tag;
        result.apiValue = apiValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isEndUser() {
        return this._tag == Tag.END_USER;
    }

    public static AccessMethodLogInfo endUser(SessionLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AccessMethodLogInfo().withTagAndEndUser(Tag.END_USER, value);
    }

    public SessionLogInfo getEndUserValue() {
        if (this._tag != Tag.END_USER) {
            throw new IllegalStateException("Invalid tag: required Tag.END_USER, but was Tag." + this._tag.name());
        }
        return this.endUserValue;
    }

    public boolean isSignInAs() {
        return this._tag == Tag.SIGN_IN_AS;
    }

    public static AccessMethodLogInfo signInAs(WebSessionLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AccessMethodLogInfo().withTagAndSignInAs(Tag.SIGN_IN_AS, value);
    }

    public WebSessionLogInfo getSignInAsValue() {
        if (this._tag != Tag.SIGN_IN_AS) {
            throw new IllegalStateException("Invalid tag: required Tag.SIGN_IN_AS, but was Tag." + this._tag.name());
        }
        return this.signInAsValue;
    }

    public boolean isContentManager() {
        return this._tag == Tag.CONTENT_MANAGER;
    }

    public static AccessMethodLogInfo contentManager(WebSessionLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AccessMethodLogInfo().withTagAndContentManager(Tag.CONTENT_MANAGER, value);
    }

    public WebSessionLogInfo getContentManagerValue() {
        if (this._tag != Tag.CONTENT_MANAGER) {
            throw new IllegalStateException("Invalid tag: required Tag.CONTENT_MANAGER, but was Tag." + this._tag.name());
        }
        return this.contentManagerValue;
    }

    public boolean isAdminConsole() {
        return this._tag == Tag.ADMIN_CONSOLE;
    }

    public static AccessMethodLogInfo adminConsole(WebSessionLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AccessMethodLogInfo().withTagAndAdminConsole(Tag.ADMIN_CONSOLE, value);
    }

    public WebSessionLogInfo getAdminConsoleValue() {
        if (this._tag != Tag.ADMIN_CONSOLE) {
            throw new IllegalStateException("Invalid tag: required Tag.ADMIN_CONSOLE, but was Tag." + this._tag.name());
        }
        return this.adminConsoleValue;
    }

    public boolean isApi() {
        return this._tag == Tag.API;
    }

    public static AccessMethodLogInfo api(ApiSessionLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AccessMethodLogInfo().withTagAndApi(Tag.API, value);
    }

    public ApiSessionLogInfo getApiValue() {
        if (this._tag != Tag.API) {
            throw new IllegalStateException("Invalid tag: required Tag.API, but was Tag." + this._tag.name());
        }
        return this.apiValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.endUserValue, this.signInAsValue, this.contentManagerValue, this.adminConsoleValue, this.apiValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AccessMethodLogInfo) {
            AccessMethodLogInfo other = (AccessMethodLogInfo)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case END_USER: {
                    return this.endUserValue == other.endUserValue || this.endUserValue.equals(other.endUserValue);
                }
                case SIGN_IN_AS: {
                    return this.signInAsValue == other.signInAsValue || this.signInAsValue.equals(other.signInAsValue);
                }
                case CONTENT_MANAGER: {
                    return this.contentManagerValue == other.contentManagerValue || this.contentManagerValue.equals(other.contentManagerValue);
                }
                case ADMIN_CONSOLE: {
                    return this.adminConsoleValue == other.adminConsoleValue || this.adminConsoleValue.equals(other.adminConsoleValue);
                }
                case API: {
                    return this.apiValue == other.apiValue || this.apiValue.equals(other.apiValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<AccessMethodLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AccessMethodLogInfo value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case END_USER: {
                    g.writeStartObject();
                    this.writeTag("end_user", g);
                    g.writeFieldName("end_user");
                    SessionLogInfo.Serializer.INSTANCE.serialize(value.endUserValue, g);
                    g.writeEndObject();
                    break;
                }
                case SIGN_IN_AS: {
                    g.writeStartObject();
                    this.writeTag("sign_in_as", g);
                    WebSessionLogInfo.Serializer.INSTANCE.serialize(value.signInAsValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case CONTENT_MANAGER: {
                    g.writeStartObject();
                    this.writeTag("content_manager", g);
                    WebSessionLogInfo.Serializer.INSTANCE.serialize(value.contentManagerValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case ADMIN_CONSOLE: {
                    g.writeStartObject();
                    this.writeTag("admin_console", g);
                    WebSessionLogInfo.Serializer.INSTANCE.serialize(value.adminConsoleValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case API: {
                    g.writeStartObject();
                    this.writeTag("api", g);
                    ApiSessionLogInfo.Serializer.INSTANCE.serialize(value.apiValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public AccessMethodLogInfo deserialize(JsonParser p) throws IOException, JsonParseException {
            AccessMethodLogInfo value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("end_user".equals(tag)) {
                SessionLogInfo fieldValue = null;
                Serializer.expectField("end_user", p);
                fieldValue = (SessionLogInfo)SessionLogInfo.Serializer.INSTANCE.deserialize(p);
                value = AccessMethodLogInfo.endUser(fieldValue);
            } else if ("sign_in_as".equals(tag)) {
                WebSessionLogInfo fieldValue = null;
                fieldValue = WebSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = AccessMethodLogInfo.signInAs(fieldValue);
            } else if ("content_manager".equals(tag)) {
                WebSessionLogInfo fieldValue = null;
                fieldValue = WebSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = AccessMethodLogInfo.contentManager(fieldValue);
            } else if ("admin_console".equals(tag)) {
                WebSessionLogInfo fieldValue = null;
                fieldValue = WebSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = AccessMethodLogInfo.adminConsole(fieldValue);
            } else if ("api".equals(tag)) {
                ApiSessionLogInfo fieldValue = null;
                fieldValue = ApiSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = AccessMethodLogInfo.api(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        END_USER,
        SIGN_IN_AS,
        CONTENT_MANAGER,
        ADMIN_CONSOLE,
        API,
        OTHER;

    }
}

