/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.GroupSelector;
import com.dropbox.core.v2.team.IncludeMembersArg;
import com.dropbox.core.v2.team.MemberAccess;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class GroupMembersAddArg
extends IncludeMembersArg {
    protected final GroupSelector group;
    protected final List<MemberAccess> members;

    public GroupMembersAddArg(GroupSelector group, List<MemberAccess> members, boolean returnMembers) {
        super(returnMembers);
        if (group == null) {
            throw new IllegalArgumentException("Required value for 'group' is null");
        }
        this.group = group;
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        for (MemberAccess x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
    }

    public GroupMembersAddArg(GroupSelector group, List<MemberAccess> members) {
        this(group, members, true);
    }

    public GroupSelector getGroup() {
        return this.group;
    }

    public List<MemberAccess> getMembers() {
        return this.members;
    }

    @Override
    public boolean getReturnMembers() {
        return this.returnMembers;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.group, this.members});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupMembersAddArg other = (GroupMembersAddArg)obj;
            return !(this.group != other.group && !this.group.equals(other.group) || this.members != other.members && !this.members.equals(other.members) || this.returnMembers != other.returnMembers);
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupMembersAddArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupMembersAddArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("group");
            GroupSelector.Serializer.INSTANCE.serialize(value.group, g);
            g.writeFieldName("members");
            StoneSerializers.list(MemberAccess.Serializer.INSTANCE).serialize(value.members, g);
            g.writeFieldName("return_members");
            StoneSerializers.boolean_().serialize((Boolean)value.returnMembers, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GroupMembersAddArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_returnMembers;
            List<MemberAccess> f_members;
            GroupSelector f_group;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_group = null;
                f_members = null;
                f_returnMembers = true;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("group".equals(field)) {
                        f_group = GroupSelector.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("members".equals(field)) {
                        f_members = StoneSerializers.list(MemberAccess.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("return_members".equals(field)) {
                        f_returnMembers = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_group == null) {
                    throw new JsonParseException(p, "Required field \"group\" missing.");
                }
                if (f_members == null) {
                    throw new JsonParseException(p, "Required field \"members\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupMembersAddArg value = new GroupMembersAddArg(f_group, f_members, f_returnMembers);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

