/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxWrappedException;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.users.BasicAccount;
import com.dropbox.core.v2.users.FullAccount;
import com.dropbox.core.v2.users.GetAccountArg;
import com.dropbox.core.v2.users.GetAccountBatchArg;
import com.dropbox.core.v2.users.GetAccountBatchError;
import com.dropbox.core.v2.users.GetAccountBatchErrorException;
import com.dropbox.core.v2.users.GetAccountError;
import com.dropbox.core.v2.users.GetAccountErrorException;
import com.dropbox.core.v2.users.SpaceUsage;
import java.util.List;

public class DbxUserUsersRequests {
    private final DbxRawClientV2 client;

    public DbxUserUsersRequests(DbxRawClientV2 client) {
        this.client = client;
    }

    BasicAccount getAccount(GetAccountArg arg) throws GetAccountErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/users/get_account", arg, false, GetAccountArg.Serializer.INSTANCE, BasicAccount.Serializer.INSTANCE, GetAccountError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new GetAccountErrorException("2/users/get_account", ex.getRequestId(), ex.getUserMessage(), (GetAccountError)((Object)ex.getErrorValue()));
        }
    }

    public BasicAccount getAccount(String accountId) throws GetAccountErrorException, DbxException {
        GetAccountArg _arg = new GetAccountArg(accountId);
        return this.getAccount(_arg);
    }

    List<BasicAccount> getAccountBatch(GetAccountBatchArg arg) throws GetAccountBatchErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/users/get_account_batch", arg, false, GetAccountBatchArg.Serializer.INSTANCE, StoneSerializers.list(BasicAccount.Serializer.INSTANCE), GetAccountBatchError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new GetAccountBatchErrorException("2/users/get_account_batch", ex.getRequestId(), ex.getUserMessage(), (GetAccountBatchError)ex.getErrorValue());
        }
    }

    public List<BasicAccount> getAccountBatch(List<String> accountIds) throws GetAccountBatchErrorException, DbxException {
        GetAccountBatchArg _arg = new GetAccountBatchArg(accountIds);
        return this.getAccountBatch(_arg);
    }

    public FullAccount getCurrentAccount() throws DbxApiException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/users/get_current_account", null, false, StoneSerializers.void_(), FullAccount.Serializer.INSTANCE, StoneSerializers.void_());
        }
        catch (DbxWrappedException ex) {
            throw new DbxApiException(ex.getRequestId(), ex.getUserMessage(), "Unexpected error response for \"get_current_account\":" + ex.getErrorValue());
        }
    }

    public SpaceUsage getSpaceUsage() throws DbxApiException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/users/get_space_usage", null, false, StoneSerializers.void_(), SpaceUsage.Serializer.INSTANCE, StoneSerializers.void_());
        }
        catch (DbxWrappedException ex) {
            throw new DbxApiException(ex.getRequestId(), ex.getUserMessage(), "Unexpected error response for \"get_space_usage\":" + ex.getErrorValue());
        }
    }
}

