/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxException;
import com.dropbox.core.LocalizedText;

public class DbxApiException
extends DbxException {
    private static final long serialVersionUID = 0L;
    private final LocalizedText userMessage;

    public DbxApiException(String requestId, LocalizedText userMessage, String message) {
        super(requestId, message);
        this.userMessage = userMessage;
    }

    public DbxApiException(String requestId, LocalizedText userMessage, String message, Throwable cause) {
        super(requestId, message, cause);
        this.userMessage = userMessage;
    }

    public LocalizedText getUserMessage() {
        return this.userMessage;
    }

    protected static String buildMessage(String routeName, LocalizedText userMessage) {
        return DbxApiException.buildMessage(routeName, userMessage, null);
    }

    protected static String buildMessage(String routeName, LocalizedText userMessage, Object errorValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("Exception in ").append(routeName);
        if (errorValue != null) {
            sb.append(": ").append(errorValue);
        }
        if (userMessage != null) {
            sb.append(" (user message: ").append(userMessage).append(")");
        }
        return sb.toString();
    }
}

