/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class FileRequestReceiveFileDetails {
    protected final String fileRequestId;
    protected final String requestTitle;
    protected final List<String> submittedFileNames;

    public FileRequestReceiveFileDetails(List<String> submittedFileNames, String fileRequestId, String requestTitle) {
        if (fileRequestId != null) {
            if (fileRequestId.length() < 1) {
                throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
            }
        }
        this.fileRequestId = fileRequestId;
        this.requestTitle = requestTitle;
        if (submittedFileNames == null) {
            throw new IllegalArgumentException("Required value for 'submittedFileNames' is null");
        }
        for (String x : submittedFileNames) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'submittedFileNames' is null");
        }
        this.submittedFileNames = submittedFileNames;
    }

    public FileRequestReceiveFileDetails(List<String> submittedFileNames) {
        this(submittedFileNames, null, null);
    }

    public List<String> getSubmittedFileNames() {
        return this.submittedFileNames;
    }

    public String getFileRequestId() {
        return this.fileRequestId;
    }

    public String getRequestTitle() {
        return this.requestTitle;
    }

    public static Builder newBuilder(List<String> submittedFileNames) {
        return new Builder(submittedFileNames);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileRequestId, this.requestTitle, this.submittedFileNames});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileRequestReceiveFileDetails other = (FileRequestReceiveFileDetails)obj;
            return (this.submittedFileNames == other.submittedFileNames || this.submittedFileNames.equals(other.submittedFileNames)) && (this.fileRequestId == other.fileRequestId || this.fileRequestId != null && this.fileRequestId.equals(other.fileRequestId)) && (this.requestTitle == other.requestTitle || this.requestTitle != null && this.requestTitle.equals(other.requestTitle));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileRequestReceiveFileDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileRequestReceiveFileDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("submitted_file_names");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.submittedFileNames, g);
            if (value.fileRequestId != null) {
                g.writeFieldName("file_request_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fileRequestId, g);
            }
            if (value.requestTitle != null) {
                g.writeFieldName("request_title");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.requestTitle, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileRequestReceiveFileDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_requestTitle;
            String f_fileRequestId;
            List<String> f_submittedFileNames;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_submittedFileNames = null;
                f_fileRequestId = null;
                f_requestTitle = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("submitted_file_names".equals(field)) {
                        f_submittedFileNames = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("file_request_id".equals(field)) {
                        f_fileRequestId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("request_title".equals(field)) {
                        f_requestTitle = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_submittedFileNames == null) {
                    throw new JsonParseException(p, "Required field \"submitted_file_names\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileRequestReceiveFileDetails value = new FileRequestReceiveFileDetails(f_submittedFileNames, f_fileRequestId, f_requestTitle);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final List<String> submittedFileNames;
        protected String fileRequestId;
        protected String requestTitle;

        protected Builder(List<String> submittedFileNames) {
            if (submittedFileNames == null) {
                throw new IllegalArgumentException("Required value for 'submittedFileNames' is null");
            }
            for (String x : submittedFileNames) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'submittedFileNames' is null");
            }
            this.submittedFileNames = submittedFileNames;
            this.fileRequestId = null;
            this.requestTitle = null;
        }

        public Builder withFileRequestId(String fileRequestId) {
            if (fileRequestId != null) {
                if (fileRequestId.length() < 1) {
                    throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
                }
                if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                    throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
                }
            }
            this.fileRequestId = fileRequestId;
            return this;
        }

        public Builder withRequestTitle(String requestTitle) {
            this.requestTitle = requestTitle;
            return this;
        }

        public FileRequestReceiveFileDetails build() {
            return new FileRequestReceiveFileDetails(this.submittedFileNames, this.fileRequestId, this.requestTitle);
        }
    }
}

