/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.graphql;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.kantenkugel.discordbot.graphql.JsonIgnore;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.internal.utils.JDALogger;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GQLQuery<T> {
    public static final Logger LOG = LoggerFactory.getLogger(GQLQuery.class);
    private static final Gson GSON = new GsonBuilder().addDeserializationExclusionStrategy(new ExclusionStrategy(){

        @Override
        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(JsonIgnore.class) != null;
        }

        @Override
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }).create();
    private static final MediaType jsonType = MediaType.parse("application/json");
    private final String remoteUrl;
    private final String auth;
    private final String queryString;
    private final Class<T> clazz;

    public GQLQuery(String remoteUrl, String auth, String queryString, Class<T> clazz) {
        this.remoteUrl = remoteUrl;
        this.auth = auth;
        this.queryString = queryString;
        this.clazz = clazz;
    }

    public static String readQuery(String queryName) {
        InputStream stream = GQLQuery.class.getClassLoader().getResourceAsStream("gqlqueries/" + queryName + ".graphql");
        if (stream == null) {
            return null;
        }
        try {
            return IOUtils.toString(stream, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Could not read query file {}", (Object)queryName, (Object)e);
            return null;
        }
    }

    public T execute() {
        return this.doCall(new JSONObject().put("query", this.queryString));
    }

    public T execute(JSONObject variables) {
        return this.doCall(new JSONObject().put("query", this.queryString).put("variables", variables));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T doCall(JSONObject data) {
        Request.Builder post = new Request.Builder().url(this.remoteUrl).post(RequestBody.create(jsonType, data.toString().getBytes()));
        if (this.auth != null) {
            post.header("Authorization", this.auth);
        }
        try (Response execute = Bot.httpClient.newCall(post.build()).execute();){
            T t;
            ArrayList<String> errors = new ArrayList<String>();
            T object = null;
            JsonReader reader = GSON.newJsonReader(execute.body().charStream());
            reader.beginObject();
            block23: while (reader.hasNext()) {
                String name;
                switch (name = reader.nextName()) {
                    case "errors": {
                        GQLQuery.readErrors(errors, reader);
                        continue block23;
                    }
                    case "data": {
                        if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                            reader.beginObject();
                            reader.nextName();
                            object = GSON.fromJson(reader, this.clazz);
                            reader.endObject();
                            continue block23;
                        }
                        reader.skipValue();
                        continue block23;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            reader.close();
            if (!errors.isEmpty()) {
                LOG.error("There was at least one GQL error:\n{}", JDALogger.getLazyString(() -> {
                    StringBuilder b = new StringBuilder();
                    for (String error : errors) {
                        b.append(error).append('\n');
                    }
                    b.setLength(b.length() - 1);
                    return b.toString();
                }));
                t = null;
                return t;
            }
            t = object;
            return t;
        }
        catch (SocketTimeoutException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (IOException e) {
            LOG.error("Error executing GQL query", e);
            return null;
        }
    }

    private static void readErrors(List<String> errorList, JsonReader reader) {
        try {
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (name.equals("message")) {
                        errorList.add(reader.nextString());
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
            }
            reader.endArray();
        }
        catch (IOException e) {
            LOG.error("There was an error parsing GQL errors", e);
        }
    }
}

