/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.commands.Command;
import com.almightyalpaca.discord.jdabutler.util.EmbedUtil;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.MessageBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;
import org.apache.commons.lang3.StringUtils;

public class HelpCommand
extends Command {
    private static final String[] ALIASES = new String[]{"info"};

    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        EmbedBuilder builder = new EmbedBuilder();
        EmbedUtil.setColor(builder);
        String prefix = Bot.config.getString("prefix");
        int size = Bot.dispatcher.getCommands().stream().filter(c -> c.getHelp() != null).mapToInt(c -> c.getName().length()).max().orElse(0) + 1 + prefix.length();
        String help = Bot.dispatcher.getCommands().stream().sorted(Comparator.comparing(Command::getName)).filter(c -> c.getHelp() != null).map(c -> String.format("`%s` - %s", StringUtils.rightPad(prefix + c.getName().toLowerCase() + "", size, "."), c.getHelp())).collect(Collectors.joining("\n"));
        builder.setAuthor(channel.getGuild().getMember(sender).getEffectiveName(), null, sender.getEffectiveAvatarUrl());
        builder.setDescription(help);
        this.reply(event, new MessageBuilder().setEmbed(builder.build()).build());
    }

    @Override
    public String[] getAliases() {
        return ALIASES;
    }

    @Override
    public String getHelp() {
        return "Prints a list of commands";
    }

    @Override
    public String getName() {
        return "help";
    }
}

