/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.NamespaceMetadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class TeamNamespacesListResult {
    protected final List<NamespaceMetadata> namespaces;
    protected final String cursor;
    protected final boolean hasMore;

    public TeamNamespacesListResult(List<NamespaceMetadata> namespaces, String cursor, boolean hasMore) {
        if (namespaces == null) {
            throw new IllegalArgumentException("Required value for 'namespaces' is null");
        }
        for (NamespaceMetadata x : namespaces) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'namespaces' is null");
        }
        this.namespaces = namespaces;
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    public List<NamespaceMetadata> getNamespaces() {
        return this.namespaces;
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.namespaces, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamNamespacesListResult other = (TeamNamespacesListResult)obj;
            return !(this.namespaces != other.namespaces && !this.namespaces.equals(other.namespaces) || this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.hasMore != other.hasMore);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamNamespacesListResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamNamespacesListResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("namespaces");
            StoneSerializers.list(NamespaceMetadata.Serializer.INSTANCE).serialize(value.namespaces, g);
            g.writeFieldName("cursor");
            StoneSerializers.string().serialize(value.cursor, g);
            g.writeFieldName("has_more");
            StoneSerializers.boolean_().serialize((Boolean)value.hasMore, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamNamespacesListResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_hasMore;
            String f_cursor;
            List<NamespaceMetadata> f_namespaces;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_namespaces = null;
                f_cursor = null;
                f_hasMore = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("namespaces".equals(field)) {
                        f_namespaces = StoneSerializers.list(NamespaceMetadata.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("has_more".equals(field)) {
                        f_hasMore = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_namespaces == null) {
                    throw new JsonParseException(p, "Required field \"namespaces\" missing.");
                }
                if (f_cursor == null) {
                    throw new JsonParseException(p, "Required field \"cursor\" missing.");
                }
                if (f_hasMore == null) {
                    throw new JsonParseException(p, "Required field \"has_more\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamNamespacesListResult value = new TeamNamespacesListResult(f_namespaces, f_cursor, f_hasMore);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

