/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v1;

import com.dropbox.core.json.JsonArrayReader;
import com.dropbox.core.json.JsonDateReader;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.Collector;
import com.dropbox.core.util.DumpWriter;
import com.dropbox.core.util.Dumpable;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v1.DbxPathV1;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public abstract class DbxEntry
extends Dumpable
implements Serializable {
    public static final long serialVersionUID = 0L;
    public final String name;
    public final String path;
    public final String iconName;
    public final boolean mightHaveThumbnail;
    public static final JsonReader<DbxEntry> Reader = new JsonReader<DbxEntry>(){

        @Override
        public final DbxEntry read(JsonParser parser) throws IOException, JsonReadException {
            return DbxEntry.read((JsonParser)parser, null).entry;
        }
    };
    public static final JsonReader<DbxEntry> ReaderMaybeDeleted = new JsonReader<DbxEntry>(){

        @Override
        public final DbxEntry read(JsonParser parser) throws IOException, JsonReadException {
            WithChildrenC wc = DbxEntry.readMaybeDeleted(parser, null);
            if (wc == null) {
                return null;
            }
            return wc.entry;
        }
    };
    private static final int FM_size = 0;
    private static final int FM_bytes = 1;
    private static final int FM_path = 2;
    private static final int FM_is_dir = 3;
    private static final int FM_is_deleted = 4;
    private static final int FM_rev = 5;
    private static final int FM_thumb_exists = 6;
    private static final int FM_icon = 7;
    private static final int FM_modified = 8;
    private static final int FM_client_mtime = 9;
    private static final int FM_hash = 10;
    private static final int FM_contents = 11;
    private static final int FM_photo_info = 12;
    private static final int FM_video_info = 13;
    private static final JsonReader.FieldMapping FM;

    private DbxEntry(String path, String iconName, boolean mightHaveThumbnail) {
        this.name = DbxPathV1.getName(path);
        this.path = path;
        this.iconName = iconName;
        this.mightHaveThumbnail = mightHaveThumbnail;
    }

    @Override
    protected void dumpFields(DumpWriter w) {
        w.v(this.path);
        w.f("iconName").v(this.iconName);
        w.f("mightHaveThumbnail").v(this.mightHaveThumbnail);
    }

    public abstract boolean isFolder();

    public abstract boolean isFile();

    public abstract Folder asFolder();

    public abstract File asFile();

    protected boolean partialEquals(DbxEntry o) {
        if (!this.name.equals(o.name)) {
            return false;
        }
        if (!this.path.equals(o.path)) {
            return false;
        }
        if (!this.iconName.equals(o.iconName)) {
            return false;
        }
        return this.mightHaveThumbnail == o.mightHaveThumbnail;
    }

    protected int partialHashCode() {
        int h = this.name.hashCode();
        h = h * 31 + this.path.hashCode();
        h = h * 31 + this.iconName.hashCode();
        h = h * 31 + this.path.hashCode();
        h = h * 31 + (this.mightHaveThumbnail ? 1 : 0);
        return h;
    }

    public static <C> WithChildrenC<C> readMaybeDeleted(JsonParser parser, Collector<DbxEntry, ? extends C> collector) throws IOException, JsonReadException {
        return DbxEntry._read(parser, collector, true);
    }

    public static <C> WithChildrenC<C> read(JsonParser parser, Collector<DbxEntry, ? extends C> collector) throws IOException, JsonReadException {
        WithChildrenC<? extends C> r = DbxEntry._read(parser, collector, false);
        assert (r != null) : "@AssumeAssertion(nullness)";
        return r;
    }

    private static <C> WithChildrenC<C> _read(JsonParser parser, Collector<DbxEntry, ? extends C> collector, boolean allowDeleted) throws IOException, JsonReadException {
        DbxEntry e;
        JsonLocation top = JsonReader.expectObjectStart(parser);
        String size = null;
        long bytes = -1L;
        String path = null;
        Boolean is_dir = null;
        Boolean is_deleted = null;
        String rev = null;
        Boolean thumb_exists = null;
        String icon = null;
        Date modified = null;
        Date client_mtime = null;
        String hash = null;
        Object contents = null;
        File.PhotoInfo photo_info = null;
        File.VideoInfo video_info = null;
        while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
            String fieldName = parser.getCurrentName();
            JsonReader.nextToken(parser);
            int fi = FM.get(fieldName);
            try {
                switch (fi) {
                    case -1: {
                        JsonReader.skipValue(parser);
                        break;
                    }
                    case 0: {
                        size = JsonReader.StringReader.readField(parser, fieldName, size);
                        break;
                    }
                    case 1: {
                        bytes = JsonReader.readUnsignedLongField(parser, fieldName, bytes);
                        break;
                    }
                    case 2: {
                        path = JsonReader.StringReader.readField(parser, fieldName, path);
                        break;
                    }
                    case 3: {
                        is_dir = JsonReader.BooleanReader.readField(parser, fieldName, is_dir);
                        break;
                    }
                    case 4: {
                        is_deleted = JsonReader.BooleanReader.readField(parser, fieldName, is_deleted);
                        break;
                    }
                    case 5: {
                        rev = JsonReader.StringReader.readField(parser, fieldName, rev);
                        break;
                    }
                    case 6: {
                        thumb_exists = JsonReader.BooleanReader.readField(parser, fieldName, thumb_exists);
                        break;
                    }
                    case 7: {
                        icon = JsonReader.StringReader.readField(parser, fieldName, icon);
                        break;
                    }
                    case 8: {
                        modified = JsonDateReader.Dropbox.readField(parser, fieldName, modified);
                        break;
                    }
                    case 9: {
                        client_mtime = JsonDateReader.Dropbox.readField(parser, fieldName, client_mtime);
                        break;
                    }
                    case 10: {
                        if (collector == null) {
                            throw new JsonReadException("not expecting \"hash\" field, since we didn't ask for children", parser.getCurrentLocation());
                        }
                        hash = JsonReader.StringReader.readField(parser, fieldName, hash);
                        break;
                    }
                    case 11: {
                        if (collector == null) {
                            throw new JsonReadException("not expecting \"contents\" field, since we didn't ask for children", parser.getCurrentLocation());
                        }
                        contents = JsonArrayReader.mk(Reader, collector).readField(parser, fieldName, (DbxEntry)contents);
                        break;
                    }
                    case 12: {
                        photo_info = PendingReader.mk(File.PhotoInfo.Reader, File.PhotoInfo.PENDING).readField(parser, fieldName, photo_info);
                        break;
                    }
                    case 13: {
                        video_info = PendingReader.mk(File.VideoInfo.Reader, File.VideoInfo.PENDING).readField(parser, fieldName, video_info);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("bad index: " + fi + ", field = \"" + fieldName + "\""));
                    }
                }
            }
            catch (JsonReadException ex) {
                throw ex.addFieldContext(fieldName);
            }
        }
        JsonReader.expectObjectEnd(parser);
        if (path == null) {
            throw new JsonReadException("missing field \"path\"", top);
        }
        if (icon == null) {
            throw new JsonReadException("missing field \"icon\"", top);
        }
        if (is_deleted == null) {
            is_deleted = Boolean.FALSE;
        }
        if (is_dir == null) {
            is_dir = Boolean.FALSE;
        }
        if (thumb_exists == null) {
            thumb_exists = Boolean.FALSE;
        }
        if (is_dir.booleanValue() && (contents != null || hash != null)) {
            if (hash == null) {
                throw new JsonReadException("missing \"hash\", when we asked for children", top);
            }
            if (contents == null) {
                throw new JsonReadException("missing \"contents\", when we asked for children", top);
            }
        }
        if (is_dir.booleanValue()) {
            e = new Folder(path, icon, thumb_exists);
        } else {
            if (size == null) {
                throw new JsonReadException("missing \"size\" for a file entry", top);
            }
            if (bytes == -1L) {
                throw new JsonReadException("missing \"bytes\" for a file entry", top);
            }
            if (modified == null) {
                throw new JsonReadException("missing \"modified\" for a file entry", top);
            }
            if (client_mtime == null) {
                throw new JsonReadException("missing \"client_mtime\" for a file entry", top);
            }
            if (rev == null) {
                throw new JsonReadException("missing \"rev\" for a file entry", top);
            }
            e = new File(path, icon, thumb_exists, bytes, size, modified, client_mtime, rev, photo_info, video_info);
        }
        if (is_deleted.booleanValue()) {
            if (allowDeleted) {
                return null;
            }
            throw new JsonReadException("not expecting \"is_deleted\" entry here", top);
        }
        return new WithChildrenC<Object>(e, hash, contents);
    }

    static {
        JsonReader.FieldMapping.Builder b = new JsonReader.FieldMapping.Builder();
        b.add("size", 0);
        b.add("bytes", 1);
        b.add("path", 2);
        b.add("is_dir", 3);
        b.add("is_deleted", 4);
        b.add("rev", 5);
        b.add("thumb_exists", 6);
        b.add("icon", 7);
        b.add("modified", 8);
        b.add("client_mtime", 9);
        b.add("hash", 10);
        b.add("contents", 11);
        b.add("photo_info", 12);
        b.add("video_info", 13);
        FM = b.build();
    }

    private static final class PendingReader<T>
    extends JsonReader<T> {
        private final JsonReader<T> reader;
        private final T pendingValue;

        public PendingReader(JsonReader<T> reader, T pendingValue) {
            this.reader = reader;
            this.pendingValue = pendingValue;
        }

        public static <T> PendingReader<T> mk(JsonReader<T> reader, T pendingValue) {
            return new PendingReader<T>(reader, pendingValue);
        }

        @Override
        public T read(JsonParser parser) throws IOException, JsonReadException {
            JsonToken token = parser.getCurrentToken();
            if (token == JsonToken.VALUE_STRING) {
                String s = parser.getText();
                if (!s.equals("pending")) {
                    throw new JsonReadException("got a string, but the value wasn't \"pending\"", parser.getTokenLocation());
                }
                parser.nextToken();
                return this.pendingValue;
            }
            return this.reader.read(parser);
        }
    }

    public static final class WithChildrenC<C>
    extends Dumpable
    implements Serializable {
        public static final long serialVersionUID = 0L;
        public final DbxEntry entry;
        public final String hash;
        public final C children;

        public WithChildrenC(DbxEntry entry, String hash, C children) {
            this.entry = entry;
            this.hash = hash;
            this.children = children;
        }

        public boolean equals(Object o) {
            return o != null && this.getClass().equals(o.getClass()) && this.equals((WithChildrenC)o);
        }

        public boolean equals(WithChildrenC<?> o) {
            if (this.children != null ? !this.children.equals(o.children) : o.children != null) {
                return false;
            }
            if (!this.entry.equals(o.entry)) {
                return false;
            }
            return !(this.hash != null ? !this.hash.equals(o.hash) : o.hash != null);
        }

        public int hashCode() {
            int result = this.entry.hashCode();
            result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
            result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
            return result;
        }

        @Override
        protected void dumpFields(DumpWriter w) {
            w.v(this.entry);
            w.f("hash").v(this.hash);
            if (this.children != null) {
                w.f("children").verbatim(this.children.toString());
            }
        }

        public static class ReaderMaybeDeleted<C>
        extends JsonReader<WithChildrenC<C>> {
            private final Collector<DbxEntry, ? extends C> collector;

            public ReaderMaybeDeleted(Collector<DbxEntry, ? extends C> collector) {
                this.collector = collector;
            }

            @Override
            public final WithChildrenC<C> read(JsonParser parser) throws IOException, JsonReadException {
                return DbxEntry.readMaybeDeleted(parser, this.collector);
            }
        }

        public static class Reader<C>
        extends JsonReader<WithChildrenC<C>> {
            private final Collector<DbxEntry, ? extends C> collector;

            public Reader(Collector<DbxEntry, ? extends C> collector) {
                this.collector = collector;
            }

            @Override
            public final WithChildrenC<C> read(JsonParser parser) throws IOException, JsonReadException {
                return DbxEntry.read(parser, this.collector);
            }
        }
    }

    public static final class WithChildren
    extends Dumpable
    implements Serializable {
        public static final long serialVersionUID = 0L;
        public final DbxEntry entry;
        public final String hash;
        public final List<DbxEntry> children;
        public static final JsonReader<WithChildren> Reader = new JsonReader<WithChildren>(){

            @Override
            public final WithChildren read(JsonParser parser) throws IOException, JsonReadException {
                WithChildrenC c = DbxEntry.read(parser, new Collector.ArrayListCollector());
                return new WithChildren(c.entry, c.hash, (List)c.children);
            }
        };
        public static final JsonReader<WithChildren> ReaderMaybeDeleted = new JsonReader<WithChildren>(){

            @Override
            public final WithChildren read(JsonParser parser) throws IOException, JsonReadException {
                WithChildrenC c = DbxEntry.readMaybeDeleted(parser, new Collector.ArrayListCollector());
                if (c == null) {
                    return null;
                }
                return new WithChildren(c.entry, c.hash, (List)c.children);
            }
        };

        public WithChildren(DbxEntry entry, String hash, List<DbxEntry> children) {
            this.entry = entry;
            this.hash = hash;
            this.children = children;
        }

        public boolean equals(Object o) {
            return o != null && this.getClass().equals(o.getClass()) && this.equals((WithChildren)o);
        }

        public boolean equals(WithChildren o) {
            if (this.children != null ? !this.children.equals(o.children) : o.children != null) {
                return false;
            }
            if (!this.entry.equals(o.entry)) {
                return false;
            }
            return !(this.hash != null ? !this.hash.equals(o.hash) : o.hash != null);
        }

        public int hashCode() {
            int result = this.entry.hashCode();
            result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
            result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
            return result;
        }

        @Override
        protected void dumpFields(DumpWriter w) {
            w.v(this.entry);
            w.f("hash").v(this.hash);
            w.f("children").v(this.children);
        }
    }

    public static final class File
    extends DbxEntry {
        public static final long serialVersionUID = 0L;
        public final long numBytes;
        public final String humanSize;
        public final Date lastModified;
        public final Date clientMtime;
        public final String rev;
        public final PhotoInfo photoInfo;
        public final VideoInfo videoInfo;
        public static final JsonReader<File> Reader = new JsonReader<File>(){

            @Override
            public final File read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = parser.getCurrentLocation();
                DbxEntry e = DbxEntry.read((JsonParser)parser, null).entry;
                if (!(e instanceof File)) {
                    throw new JsonReadException("Expecting a file entry, got a folder entry", top);
                }
                return (File)e;
            }
        };
        public static final JsonReader<File> ReaderMaybeDeleted = new JsonReader<File>(){

            @Override
            public final File read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = parser.getCurrentLocation();
                WithChildrenC wc = DbxEntry._read(parser, null, true);
                if (wc == null) {
                    return null;
                }
                DbxEntry e = wc.entry;
                if (!(e instanceof File)) {
                    throw new JsonReadException("Expecting a file entry, got a folder entry", top);
                }
                return (File)e;
            }
        };

        public File(String path, String iconName, boolean mightHaveThumbnail, long numBytes, String humanSize, Date lastModified, Date clientMtime, String rev, PhotoInfo photoInfo, VideoInfo videoInfo) {
            super(path, iconName, mightHaveThumbnail);
            this.numBytes = numBytes;
            this.humanSize = humanSize;
            this.lastModified = lastModified;
            this.clientMtime = clientMtime;
            this.rev = rev;
            this.photoInfo = photoInfo;
            this.videoInfo = videoInfo;
        }

        public File(String path, String iconName, boolean mightHaveThumbnail, long numBytes, String humanSize, Date lastModified, Date clientMtime, String rev) {
            this(path, iconName, mightHaveThumbnail, numBytes, humanSize, lastModified, clientMtime, rev, null, null);
        }

        @Override
        protected void dumpFields(DumpWriter w) {
            super.dumpFields(w);
            w.f("numBytes").v(this.numBytes);
            w.f("humanSize").v(this.humanSize);
            w.f("lastModified").v(this.lastModified);
            w.f("clientMtime").v(this.clientMtime);
            w.f("rev").v(this.rev);
            File.nullablePendingField(w, "photoInfo", this.photoInfo, PhotoInfo.PENDING);
            File.nullablePendingField(w, "videoInfo", this.videoInfo, VideoInfo.PENDING);
        }

        private static <T extends Dumpable> void nullablePendingField(DumpWriter w, String fieldName, T value, T pendingValue) {
            if (value == null) {
                return;
            }
            w.f(fieldName);
            if (value == pendingValue) {
                w.verbatim("pending");
            } else {
                w.v(value);
            }
        }

        @Override
        protected String getTypeName() {
            return "File";
        }

        @Override
        public boolean isFolder() {
            return false;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public Folder asFolder() {
            throw new RuntimeException("not a folder");
        }

        @Override
        public File asFile() {
            return this;
        }

        public boolean equals(Object o) {
            return o != null && this.getClass().equals(o.getClass()) && this.equals((File)o);
        }

        public boolean equals(File o) {
            if (!this.partialEquals(o)) {
                return false;
            }
            if (this.numBytes != o.numBytes) {
                return false;
            }
            if (!this.humanSize.equals(o.humanSize)) {
                return false;
            }
            if (!this.lastModified.equals(o.lastModified)) {
                return false;
            }
            if (!this.clientMtime.equals(o.clientMtime)) {
                return false;
            }
            if (!this.rev.equals(o.rev)) {
                return false;
            }
            if (!LangUtil.nullableEquals(this.photoInfo, o.photoInfo)) {
                return false;
            }
            return LangUtil.nullableEquals(this.videoInfo, o.videoInfo);
        }

        public int hashCode() {
            int h = this.partialHashCode();
            h = h * 31 + (int)this.numBytes;
            h = h * 31 + this.lastModified.hashCode();
            h = h * 31 + this.clientMtime.hashCode();
            h = h * 31 + this.rev.hashCode();
            h = h * 31 + LangUtil.nullableHashCode(this.photoInfo);
            h = h * 31 + LangUtil.nullableHashCode(this.videoInfo);
            return h;
        }

        public static class Location
        extends Dumpable {
            public final double latitude;
            public final double longitude;
            public static JsonReader<Location> Reader = new JsonReader<Location>(){

                @Override
                public Location read(JsonParser parser) throws IOException, JsonReadException {
                    Location location = null;
                    if (JsonArrayReader.isArrayStart(parser)) {
                        JsonReader.expectArrayStart(parser);
                        double latitude = JsonReader.readDouble(parser);
                        double longitude = JsonReader.readDouble(parser);
                        location = new Location(latitude, longitude);
                        JsonReader.expectArrayEnd(parser);
                    } else {
                        JsonReader.skipValue(parser);
                    }
                    return location;
                }
            };

            public Location(double latitude, double longitude) {
                this.latitude = latitude;
                this.longitude = longitude;
            }

            @Override
            protected void dumpFields(DumpWriter w) {
                w.f("latitude").v(this.latitude);
                w.f("longitude").v(this.longitude);
            }

            public int hashCode() {
                long latitudeBits = Double.doubleToLongBits(this.latitude);
                long longitudeBits = Double.doubleToLongBits(this.longitude);
                int hash = 17;
                hash = 31 * hash + (int)(latitudeBits ^ latitudeBits >>> 32);
                hash = 31 * hash + (int)(longitudeBits ^ longitudeBits >>> 32);
                return hash;
            }

            public boolean equals(Object o) {
                return o != null && this.getClass().equals(o.getClass()) && this.equals((Location)o);
            }

            public boolean equals(Location o) {
                if (this.latitude != o.latitude) {
                    return false;
                }
                return this.longitude == o.longitude;
            }
        }

        public static final class VideoInfo
        extends Dumpable {
            public final Date timeTaken;
            public final Location location;
            public final Long duration;
            public static JsonReader<VideoInfo> Reader = new JsonReader<VideoInfo>(){

                @Override
                public VideoInfo read(JsonParser parser) throws IOException, JsonReadException {
                    JsonReader.expectObjectStart(parser);
                    Location location = null;
                    Date time_taken = null;
                    Long duration = null;
                    while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                        String fieldName = parser.getCurrentName();
                        JsonReader.nextToken(parser);
                        if (fieldName.equals("lat_long")) {
                            location = Location.Reader.read(parser);
                            continue;
                        }
                        if (fieldName.equals("time_taken")) {
                            time_taken = JsonDateReader.Dropbox.readOptional(parser);
                            continue;
                        }
                        if (fieldName.equals("duration")) {
                            duration = JsonReader.UnsignedLongReader.readOptional(parser);
                            continue;
                        }
                        JsonReader.skipValue(parser);
                    }
                    JsonReader.expectObjectEnd(parser);
                    return new VideoInfo(time_taken, location, duration);
                }
            };
            public static final VideoInfo PENDING = new VideoInfo(null, null, null);

            public VideoInfo(Date timeTaken, Location location, Long duration) {
                this.timeTaken = timeTaken;
                this.location = location;
                this.duration = duration;
            }

            @Override
            protected void dumpFields(DumpWriter w) {
                w.f("timeTaken").v(this.timeTaken);
                w.f("location").v(this.location);
                w.f("duration").v(this.duration);
            }

            public boolean equals(Object o) {
                return o != null && this.getClass().equals(o.getClass()) && this.equals((VideoInfo)o);
            }

            public boolean equals(VideoInfo o) {
                if (o == PENDING || this == PENDING) {
                    return o == this;
                }
                if (!LangUtil.nullableEquals(this.timeTaken, o.timeTaken)) {
                    return false;
                }
                if (!LangUtil.nullableEquals(this.location, o.location)) {
                    return false;
                }
                return LangUtil.nullableEquals(this.duration, o.duration);
            }

            public int hashCode() {
                int h = 0;
                h = h * 31 + LangUtil.nullableHashCode(this.timeTaken);
                h = h * 31 + LangUtil.nullableHashCode(this.location);
                h = h * 31 + LangUtil.nullableHashCode(this.duration);
                return h;
            }
        }

        public static final class PhotoInfo
        extends Dumpable {
            public final Date timeTaken;
            public final Location location;
            public static JsonReader<PhotoInfo> Reader = new JsonReader<PhotoInfo>(){

                @Override
                public PhotoInfo read(JsonParser parser) throws IOException, JsonReadException {
                    JsonReader.expectObjectStart(parser);
                    Date time_taken = null;
                    Location location = null;
                    while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                        String fieldName = parser.getCurrentName();
                        JsonReader.nextToken(parser);
                        if (fieldName.equals("lat_long")) {
                            location = Location.Reader.read(parser);
                            continue;
                        }
                        if (fieldName.equals("time_taken")) {
                            time_taken = JsonDateReader.Dropbox.readOptional(parser);
                            continue;
                        }
                        JsonReader.skipValue(parser);
                    }
                    JsonReader.expectObjectEnd(parser);
                    return new PhotoInfo(time_taken, location);
                }
            };
            public static final PhotoInfo PENDING = new PhotoInfo(null, null);

            public PhotoInfo(Date timeTaken, Location location) {
                this.timeTaken = timeTaken;
                this.location = location;
            }

            @Override
            protected void dumpFields(DumpWriter w) {
                w.f("timeTaken").v(this.timeTaken);
                w.f("location").v(this.location);
            }

            public boolean equals(Object o) {
                return o != null && this.getClass().equals(o.getClass()) && this.equals((PhotoInfo)o);
            }

            public boolean equals(PhotoInfo o) {
                if (o == PENDING || this == PENDING) {
                    return o == this;
                }
                if (!LangUtil.nullableEquals(this.timeTaken, o.timeTaken)) {
                    return false;
                }
                return LangUtil.nullableEquals(this.location, o.location);
            }

            public int hashCode() {
                int h = 0;
                h = h * 31 + LangUtil.nullableHashCode(this.timeTaken);
                h = h * 31 + LangUtil.nullableHashCode(this.location);
                return h;
            }
        }
    }

    public static final class Folder
    extends DbxEntry {
        public static final long serialVersionUID = 0L;
        public static final JsonReader<Folder> Reader = new JsonReader<Folder>(){

            @Override
            public final Folder read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = parser.getCurrentLocation();
                DbxEntry e = DbxEntry.read((JsonParser)parser, null).entry;
                if (!(e instanceof Folder)) {
                    throw new JsonReadException("Expecting a file entry, got a folder entry", top);
                }
                return (Folder)e;
            }
        };

        public Folder(String path, String iconName, boolean mightHaveThumbnail) {
            super(path, iconName, mightHaveThumbnail);
        }

        @Override
        protected String getTypeName() {
            return "Folder";
        }

        @Override
        public boolean isFolder() {
            return true;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public Folder asFolder() {
            return this;
        }

        @Override
        public File asFile() {
            throw new RuntimeException("not a file");
        }

        public boolean equals(Object o) {
            return o != null && this.getClass().equals(o.getClass()) && this.equals((Folder)o);
        }

        public boolean equals(Folder o) {
            return this.partialEquals(o);
        }

        public int hashCode() {
            return this.partialHashCode();
        }
    }
}

