/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands;

import com.almightyalpaca.discord.jdabutler.commands.Command;
import com.almightyalpaca.discord.jdabutler.util.EmbedUtil;
import com.kantenkugel.discordbot.versioncheck.VersionCheckerRegistry;
import com.kantenkugel.discordbot.versioncheck.changelog.ChangelogProvider;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.util.List;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class ChangelogCommand
extends Command {
    private static final String[] ALIASES = new String[]{"changes"};

    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        ChangelogProvider clProvider;
        EmbedBuilder eb = new EmbedBuilder();
        EmbedUtil.setColor(eb);
        VersionedItem item = null;
        int versionStart = 1;
        String[] args = null;
        if (!content.trim().isEmpty()) {
            args = content.trim().split("[\\s-]", 4);
            item = VersionCheckerRegistry.getItem(args[0]);
        }
        if (item == null) {
            versionStart = 0;
            item = VersionCheckerRegistry.getItem("jda");
        }
        if ((clProvider = item.getChangelogProvider()) == null) {
            this.reply(event, "No Changelogs set up for " + item.getName());
            return;
        }
        if (!clProvider.supportsIndividualLogs() || args == null || args.length == versionStart) {
            this.reply(event, String.format("Changelogs for %s can be found here: %s", item.getName(), clProvider.getChangelogUrl()));
            return;
        }
        eb.setTitle("Changelog(s) for " + item.getName(), clProvider.getChangelogUrl());
        if (args.length == versionStart + 1) {
            ChangelogProvider.Changelog changelog = clProvider.getChangelog(args[versionStart]);
            if (changelog == null) {
                this.reply(event, "The specified version does not exist");
                return;
            }
            if (changelog.getChangelogUrl() == null) {
                eb.appendDescription("**").appendDescription(changelog.getTitle()).appendDescription("**:\n");
            } else {
                eb.appendDescription("[").appendDescription(changelog.getTitle()).appendDescription("](").appendDescription(changelog.getChangelogUrl()).appendDescription("):\n");
            }
            if (changelog.getChangeset().isEmpty()) {
                eb.appendDescription("No changes available for this version");
            } else {
                eb.appendDescription(String.join((CharSequence)"\n", changelog.getChangeset()));
            }
        } else {
            List<ChangelogProvider.Changelog> changelogs = clProvider.getChangelogs(args[versionStart], args[versionStart + 1]);
            if (changelogs.size() == 0) {
                this.reply(event, "No Changelogs found in given range");
                return;
            }
            int fields = 0;
            for (ChangelogProvider.Changelog changelog : changelogs) {
                String body = String.join((CharSequence)"\n", changelog.getChangeset());
                if (body.length() > 1024) {
                    body = changelog.getChangelogUrl() == null ? "Too large to show." : "[Link](" + changelog.getChangelogUrl() + ") Too large to show.";
                }
                eb.addField(changelog.getTitle(), body, false);
                if (++fields != 19 || changelogs.size() <= 20) continue;
                eb.addField("...", "Embed limit reached. See [Online changelog](" + clProvider.getChangelogUrl() + ')', false);
            }
        }
        MessageEmbed embed = eb.build();
        if (embed.isSendable(AccountType.BOT)) {
            this.reply(event, embed);
        } else {
            this.reply(event, "Too much content. Please restrict your build range");
        }
    }

    @Override
    public String[] getAliases() {
        return ALIASES;
    }

    @Override
    public String getHelp() {
        return "`!changelog VERSION [VERSION2]` - Shows changes for some JDA version";
    }

    @Override
    public String getName() {
        return "changelog";
    }
}

