/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck;

import com.kantenkugel.discordbot.versioncheck.DependencyType;
import com.kantenkugel.discordbot.versioncheck.RepoType;
import com.kantenkugel.discordbot.versioncheck.VersionChecker;
import com.kantenkugel.discordbot.versioncheck.items.ButlerItem;
import com.kantenkugel.discordbot.versioncheck.items.JDAItem;
import com.kantenkugel.discordbot.versioncheck.items.JDActionItem;
import com.kantenkugel.discordbot.versioncheck.items.LavalinkItem;
import com.kantenkugel.discordbot.versioncheck.items.SimpleVersionedItem;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import com.kantenkugel.discordbot.versioncheck.items.YuiItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class VersionCheckerRegistry {
    public static final VersionedItem EXPERIMENTAL_ITEM = new SimpleVersionedItem(null, null, null, null, null).setAnnouncementChannelId(289742061220134912L).setAnnouncementRoleId(289744006433472513L);
    private static final Map<String, VersionedItem> checkedItems = new LinkedHashMap<String, VersionedItem>();
    private static boolean initialized = false;

    public static void addItem(String name, String repoType, String groupId, String artifactId, String url) {
        VersionCheckerRegistry.addItem(new SimpleVersionedItem(name, RepoType.fromString(repoType), DependencyType.DEFAULT, groupId, artifactId).setUrl(url));
    }

    public static boolean addItem(VersionedItem item) {
        String version = VersionChecker.getVersion(item);
        if (version != null) {
            item.setVersion(version);
            checkedItems.put(item.getName().toLowerCase(), item);
            return true;
        }
        return false;
    }

    public static void removeItem(VersionedItem item) {
        VersionCheckerRegistry.removeItem(item.getName());
    }

    public static void removeItem(String name) {
        checkedItems.remove(name.toLowerCase());
    }

    public static VersionedItem getItem(String name) {
        String lowerName = name.toLowerCase();
        VersionedItem item = checkedItems.get(lowerName);
        if (item == null) {
            item = VersionCheckerRegistry.getVersionedItems().stream().filter(i -> i.getAliases() != null && i.getAliases().contains(lowerName)).findAny().orElse(null);
        }
        return item;
    }

    public static List<VersionedItem> getItemsFromString(String spaceDelimString, boolean prependJDA) {
        if (prependJDA) {
            spaceDelimString = "jda " + spaceDelimString;
        }
        String[] split = spaceDelimString.trim().toLowerCase().split("\\s+");
        return Arrays.stream(split).map(VersionCheckerRegistry::getItem).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static Collection<VersionedItem> getVersionedItems() {
        return checkedItems.values();
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        VersionCheckerRegistry.register();
        VersionChecker.initUpdateLoop();
    }

    private static void register() {
        VersionCheckerRegistry.addItem(new JDAItem());
        VersionCheckerRegistry.addItem(new SimpleVersionedItem("Lavaplayer", RepoType.JCENTER, DependencyType.DEFAULT, "com.sedmelluq", "lavaplayer").setUrl("https://github.com/sedmelluq/lavaplayer#lavaplayer---audio-player-library-for-discord").setAliases("lava", "player").setAnnouncementRoleId(241948768113524762L).setAnnouncementChannelId(263484072389640193L).addAnnouncementWhitelist(138092389008015360L));
        VersionCheckerRegistry.addItem(new SimpleVersionedItem("JDA-Utilities", RepoType.JCENTER, DependencyType.POM, "com.jagrosh", "jda-utilities").setUrl("https://github.com/JDA-Applications/JDA-Utilities").setAliases("utils", "jda-utils").setAnnouncementRoleId(417331483091664896L).setAnnouncementChannelId(384483855475933184L).addAnnouncementWhitelist(113156185389092864L, 211393686628597761L));
        VersionCheckerRegistry.addItem(new ButlerItem());
        VersionCheckerRegistry.addItem(new YuiItem());
        VersionCheckerRegistry.addItem(new JDActionItem());
        VersionCheckerRegistry.addItem(new LavalinkItem());
        VersionCheckerRegistry.addItem(new SimpleVersionedItem("java-discord-rpc", RepoType.JCENTER, DependencyType.DEFAULT, "club.minnced", "java-discord-rpc").setUrl("https://github.com/MinnDevelopment/java-discord-rpc").setAliases("rpc"));
    }
}

