/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands;

import com.almightyalpaca.discord.jdabutler.commands.Command;
import com.almightyalpaca.discord.jdabutler.util.StringUtils;
import java.lang.management.ManagementFactory;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class UptimeCommand
extends Command {
    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        long duration = ManagementFactory.getRuntimeMXBean().getUptime();
        long years = duration / 31104000000L;
        long months = duration / 2592000000L % 12L;
        long days = duration / 86400000L % 30L;
        long hours = duration / 3600000L % 24L;
        long minutes = duration / 60000L % 60L;
        long seconds = duration / 1000L % 60L;
        String uptime = "";
        uptime = uptime + (years == 0L ? "" : years + " Year" + (years > 1L ? "s" : "") + ", ");
        uptime = uptime + (months == 0L ? "" : months + " Month" + (months > 1L ? "s" : "") + ", ");
        uptime = uptime + (days == 0L ? "" : days + " Day" + (days > 1L ? "s" : "") + ", ");
        uptime = uptime + (hours == 0L ? "" : hours + " Hour" + (hours > 1L ? "s" : "") + ", ");
        uptime = uptime + (minutes == 0L ? "" : minutes + " Minute" + (minutes > 1L ? "s" : "") + ", ");
        uptime = uptime + (seconds == 0L ? "" : seconds + " Second" + (seconds > 1L ? "s" : "") + ", ");
        uptime = StringUtils.replaceLast(uptime, ", ", "");
        uptime = StringUtils.replaceLast(uptime, ",", " and");
        this.reply(event, uptime);
    }

    @Override
    public String getHelp() {
        return "Shows my uptime";
    }

    @Override
    public String getName() {
        return "uptime";
    }
}

